/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderCreatesSurrogates;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderMalformedException;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-3A!\u0002\u0004\u0001'!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C)9!)a\u0006\u0001C\u0003_!)q\b\u0001C\u0003\u0001\n1\")\u001b;t\u0007\"\f'o]3u\t\u0016\u001cw\u000eZ3s+R3\u0005H\u0003\u0002\b\u0011\u000591\r[1sg\u0016$(BA\u0005\u000b\u0003)\u0001(o\\2fgN|'o\u001d\u0006\u0003\u00171\t!![8\u000b\u00055q\u0011\u0001\u00033bM\u001a|G-\u001b7\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u0016-5\ta!\u0003\u0002\u0018\r\t\u0019#)\u001b;t\u0007\"\f'o]3u\t\u0016\u001cw\u000eZ3s\u0007J,\u0017\r^3t'V\u0014(o\\4bi\u0016\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u001b!\t)\u0002!\u0001\u000beK\u000e|G-Z(oKVs\u0017nY8eK\u000eC\u0017M\u001d\u000b\u0004;\rJ\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B\"iCJDQ\u0001\n\u0002A\u0002\u0015\n1\u0001Z5t!\t1s%D\u0001\u000b\u0013\tA#B\u0001\u000eJ]B,HoU8ve\u000e,G)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003+\u0005\u0001\u00071&A\u0003gS:4w\u000e\u0005\u0002'Y%\u0011QF\u0003\u0002\u000b\r>\u0014X.\u0019;J]\u001a|\u0017!F2iK\u000e\\7i\u001c8uS:,\u0018\r^5p]\nKH/\u001a\u000b\u0005aM\"\u0014\b\u0005\u0002\u001fc%\u0011!g\b\u0002\u0005+:LG\u000fC\u0003%\u0007\u0001\u0007Q\u0005C\u00036\u0007\u0001\u0007a'\u0001\u0003csR,\u0007C\u0001\u00108\u0013\tAtDA\u0002J]RDQAO\u0002A\u0002Y\n\u0011CY5ug\u000e{gn];nK\u0012\u001cvNR1sQ\t\u0019A\b\u0005\u0002\u001f{%\u0011ah\b\u0002\u0007S:d\u0017N\\3\u0002\u001b\rDWmY6Pm\u0016\u0014Hn\u001c8h)\u0019\u0001\u0014iQ#H\u0013\")!\t\u0002a\u0001m\u0005)!-\u001f;fc!)A\t\u0002a\u0001m\u0005)Q.Y:lc!)a\t\u0002a\u0001m\u0005)!-\u001f;fe!)\u0001\n\u0002a\u0001m\u0005)Q.Y:le!)!\b\u0002a\u0001m!\u0012A\u0001\u0010")
public class BitsCharsetDecoderUTF8
extends BitsCharsetDecoderCreatesSurrogates {
    @Override
    public char decodeOneUnicodeChar(InputSourceDataInputStream dis, FormatInfo finfo) {
        int byte1 = this.getByte(dis, 0);
        if ((byte1 & 0x80) == 0) {
            return (char)byte1;
        }
        if ((byte1 & 0xE0) == 192) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            this.checkOverlong(byte1, 31, 0, 0, 16);
            int cp = (byte1 & 0x1F) << 6 | byte2 & 0x3F;
            return (char)cp;
        }
        if ((byte1 & 0xF0) == 224) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            this.checkOverlong(byte1, 15, byte2, 32, 24);
            int cp = (byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F;
            if (cp >= 55296 && cp <= 57343) {
                throw new BitsCharsetDecoderMalformedException(24);
            }
            return (char)cp;
        }
        if ((byte1 & 0xF8) == 240) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            int byte4 = this.getByte(dis, 24);
            this.checkContinuationByte(dis, byte4, 32);
            this.checkOverlong(byte1, 7, byte2, 48, 32);
            int cp = (byte1 & 0xF) << 18 | (byte2 & 0x3F) << 12 | (byte3 & 0x3F) << 6 | byte4 & 0x3F;
            if (cp > 0x10FFFF) {
                throw new BitsCharsetDecoderMalformedException(32);
            }
            char high = Character.highSurrogate(cp);
            this.setLowSurrogate(Character.lowSurrogate(cp));
            return high;
        }
        if ((byte1 & 0xFC) == 248) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            int byte4 = this.getByte(dis, 24);
            this.checkContinuationByte(dis, byte4, 32);
            int byte5 = this.getByte(dis, 32);
            this.checkContinuationByte(dis, byte5, 40);
            throw new BitsCharsetDecoderMalformedException(40);
        }
        if ((byte1 & 0xFE) == 252) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            int byte4 = this.getByte(dis, 24);
            this.checkContinuationByte(dis, byte4, 32);
            int byte5 = this.getByte(dis, 32);
            this.checkContinuationByte(dis, byte5, 40);
            int byte6 = this.getByte(dis, 40);
            this.checkContinuationByte(dis, byte6, 48);
            throw new BitsCharsetDecoderMalformedException(48);
        }
        throw new BitsCharsetDecoderMalformedException(8);
    }

    public final void checkContinuationByte(InputSourceDataInputStream dis, int n, int bitsConsumedSoFar) {
        if ((n & 0xC0) != 128) {
            dis.setBitPos0b(dis.bitPos0b() - 8L);
            throw new BitsCharsetDecoderMalformedException(bitsConsumedSoFar - 8);
        }
    }

    public final void checkOverlong(int byte1, int mask1, int byte2, int mask2, int bitsConsumedSoFar) {
        if ((byte1 & mask1) == 0 && (byte2 & mask2) == 0) {
            throw new BitsCharsetDecoderMalformedException(bitsConsumedSoFar);
        }
    }
}

