/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import com.ibm.icu.util.ULocale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.daffodil.lib.cookers.Converter;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class LocaleConverter$
implements Converter<String, ULocale> {
    public static final LocaleConverter$ MODULE$ = new LocaleConverter$();
    private static final String regex;
    private static final Pattern localePattern;

    static {
        Converter.$init$((Converter)MODULE$);
        regex = "([A-Za-z]{1,8}([-_][A-Za-z0-9]{1,8})*)";
        localePattern = Pattern.compile(MODULE$.regex());
    }

    public Object convertRuntime(Object b, ThrowsSDE context, boolean forUnparse) {
        return Converter.convertRuntime$((Converter)this, (Object)b, (ThrowsSDE)context, (boolean)forUnparse);
    }

    public Object convertConstant(Object b, ThrowsSDE context, boolean forUnparse) {
        return Converter.convertConstant$((Converter)this, (Object)b, (ThrowsSDE)context, (boolean)forUnparse);
    }

    public String regex() {
        return regex;
    }

    public Pattern localePattern() {
        return localePattern;
    }

    public ULocale convert(String b, ThrowsSDE context, boolean forUnparse) {
        Matcher m = this.localePattern().matcher(b);
        if (m.matches()) {
            String canonicalCalLang = ULocale.canonicalize((String)b);
            if (canonicalCalLang == null) {
                throw Assert$.MODULE$.abort("Invariant broken: canonicalCalLang.ne(null)");
            }
            ULocale l = new ULocale(canonicalCalLang);
            return l;
        }
        throw context.schemaDefinitionError("dfdl:calendarLanguage property syntax error. Must match '%s' (ex: 'en_us' or 'de_1996'), but was '%s'.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.regex(), b}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LocaleConverter$.class);
    }

    private LocaleConverter$() {
    }
}

