/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.common;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.ElementCollection;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OrderColumn;
import org.apache.cxf.rs.security.oauth2.common.AccessToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@MappedSuperclass
public abstract class ServerAccessToken
extends AccessToken {
    private static final long serialVersionUID = 638776204861456064L;
    private String grantType;
    private Client client;
    private List<OAuthPermission> scopes = new LinkedList<OAuthPermission>();
    private UserSubject subject;
    private List<String> audiences = new LinkedList<String>();
    private String clientCodeVerifier;
    private String nonce;
    private String responseType;
    private String grantCode;
    private Map<String, String> extraProperties = new LinkedHashMap<String, String>();

    protected ServerAccessToken() {
    }

    protected ServerAccessToken(Client client, String tokenType, String tokenKey, long expiresIn) {
        this(client, tokenType, tokenKey, expiresIn, OAuthUtils.getIssuedAt());
    }

    protected ServerAccessToken(Client client, String tokenType, String tokenKey, long expiresIn, long issuedAt) {
        super(tokenType, tokenKey, expiresIn, issuedAt);
        this.client = client;
    }

    protected ServerAccessToken(ServerAccessToken token, String key) {
        super(token.getTokenType(), key, token.getExpiresIn(), token.getIssuedAt(), token.getRefreshToken(), token.getParameters());
        this.client = token.getClient();
        this.grantType = token.getGrantType();
        this.scopes = token.getScopes();
        this.audiences = token.getAudiences();
        this.subject = token.getSubject();
        this.responseType = token.getResponseType();
        this.clientCodeVerifier = token.getClientCodeVerifier();
        this.nonce = token.getNonce();
        this.grantCode = token.getGrantCode();
    }

    protected static ServerAccessToken validateTokenType(ServerAccessToken token, String expectedType) {
        if (!token.getTokenType().equals(expectedType)) {
            throw new OAuthServiceException("server_error");
        }
        return token;
    }

    @ManyToOne
    public Client getClient() {
        return this.client;
    }

    public void setClient(Client c) {
        this.client = c;
    }

    @ManyToMany(fetch=FetchType.EAGER)
    public List<OAuthPermission> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<OAuthPermission> scopes) {
        this.scopes = scopes;
    }

    @ManyToOne
    public UserSubject getSubject() {
        return this.subject;
    }

    public void setSubject(UserSubject subject) {
        this.subject = subject;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public String getClientCodeVerifier() {
        return this.clientCodeVerifier;
    }

    public void setClientCodeVerifier(String clientCodeVerifier) {
        this.clientCodeVerifier = clientCodeVerifier;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="extraPropName")
    public Map<String, String> getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Map<String, String> extraProperties) {
        this.extraProperties = extraProperties;
    }

    public String getGrantCode() {
        return this.grantCode;
    }

    public void setGrantCode(String grantCode) {
        this.grantCode = grantCode;
    }
}

