/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;
import java.util.stream.LongStream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.LongRange;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class LongRangeTest
extends AbstractLangTest {
    private LongRange range1;
    private LongRange range2;
    private LongRange range3;
    private LongRange rangeFull;

    LongRangeTest() {
    }

    private static LongRange of(int min, int max) {
        return LongRange.of((long)min, (long)max);
    }

    private static LongRange of(Long min, Long max) {
        return LongRange.of((Long)min, (Long)max);
    }

    @BeforeEach
    public void setUp() {
        this.range1 = LongRangeTest.of(10, 20);
        this.range2 = LongRangeTest.of(10, 20);
        this.range3 = LongRangeTest.of(-2, -1);
        this.rangeFull = LongRangeTest.of(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Test
    void testContainsInt() {
        Assertions.assertFalse((boolean)this.range1.contains(null));
        Assertions.assertFalse((boolean)this.range1.contains((Object)5L));
        Assertions.assertTrue((boolean)this.range1.contains((Object)10L));
        Assertions.assertTrue((boolean)this.range1.contains((Object)15L));
        Assertions.assertTrue((boolean)this.range1.contains((Object)20L));
        Assertions.assertFalse((boolean)this.range1.contains((Object)25L));
    }

    @Test
    void testContainsLong() {
        Assertions.assertFalse((boolean)this.range1.contains(null));
        Assertions.assertTrue((boolean)this.rangeFull.contains((Object)Long.MAX_VALUE));
        Assertions.assertTrue((boolean)this.rangeFull.contains((Object)Long.MIN_VALUE));
        Assertions.assertTrue((boolean)this.rangeFull.contains((Object)0x80000000L));
        Assertions.assertTrue((boolean)this.rangeFull.contains((Object)-2147483649L));
        Assertions.assertTrue((boolean)this.rangeFull.contains((Object)Integer.MAX_VALUE));
        Assertions.assertTrue((boolean)this.rangeFull.contains((Object)Integer.MIN_VALUE));
        Assertions.assertFalse((boolean)this.range1.contains((Object)5L));
        Assertions.assertTrue((boolean)this.range1.contains((Object)10L));
        Assertions.assertTrue((boolean)this.range1.contains((Object)15L));
        Assertions.assertTrue((boolean)this.range1.contains((Object)20L));
        Assertions.assertFalse((boolean)this.range1.contains((Object)25L));
    }

    @Test
    void testContainsRange() {
        Assertions.assertFalse((boolean)this.range1.containsRange(null));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(12L), (Comparable)Long.valueOf(18L))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)LongRangeTest.of(12, 18)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(32L), (Comparable)Long.valueOf(45L))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)LongRangeTest.of(32, 45)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(2L), (Comparable)Long.valueOf(8L))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)LongRangeTest.of(2, 8)));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(20L))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)LongRangeTest.of(10, 20)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(9L), (Comparable)Long.valueOf(14L))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)LongRangeTest.of(9, 14)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(16L), (Comparable)Long.valueOf(21L))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)LongRangeTest.of(16, 21)));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(19L))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)LongRangeTest.of(10, 19)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(21L))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)LongRangeTest.of(10, 21)));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(11L), (Comparable)Long.valueOf(20L))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)LongRangeTest.of(11, 20)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(9L), (Comparable)Long.valueOf(20L))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)LongRangeTest.of(9, 20)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Long.valueOf(-11L), (Comparable)Long.valueOf(-18L))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)LongRangeTest.of(-11, -18)));
    }

    @Test
    void testElementCompareTo() {
        LangAssertions.assertNullPointerException(() -> this.range1.elementCompareTo(null));
        Assertions.assertEquals((int)-1, (int)this.range1.elementCompareTo((Object)5L));
        Assertions.assertEquals((int)0, (int)this.range1.elementCompareTo((Object)10L));
        Assertions.assertEquals((int)0, (int)this.range1.elementCompareTo((Object)15L));
        Assertions.assertEquals((int)0, (int)this.range1.elementCompareTo((Object)20L));
        Assertions.assertEquals((int)1, (int)this.range1.elementCompareTo((Object)25L));
    }

    @Test
    void testEqualsObject() {
        Assertions.assertEquals((Object)this.range1, (Object)this.range1);
        Assertions.assertEquals((Object)this.range1, (Object)this.range2);
        Assertions.assertEquals((Object)this.range2, (Object)this.range2);
        Assertions.assertEquals((Object)this.range1, (Object)this.range1);
        Assertions.assertEquals((Object)this.range2, (Object)this.range2);
        Assertions.assertEquals((Object)this.range3, (Object)this.range3);
        Assertions.assertNotEquals((Object)this.range2, (Object)this.range3);
        Assertions.assertNotEquals(null, (Object)this.range2);
        Assertions.assertNotEquals((Object)"Ni!", (Object)this.range2);
    }

    @Test
    void testFit() {
        Assertions.assertEquals((Long)((Long)this.range1.getMinimum()), (Long)((Long)this.range1.fit((Object)Integer.MIN_VALUE)));
        Assertions.assertEquals((Long)((Long)this.range1.getMinimum()), (Long)((Long)this.range1.fit((Object)((Long)this.range1.getMinimum()))));
        Assertions.assertEquals((Long)((Long)this.range1.getMaximum()), (Long)((Long)this.range1.fit((Object)Integer.MAX_VALUE)));
        Assertions.assertEquals((Long)((Long)this.range1.getMaximum()), (Long)((Long)this.range1.fit((Object)((Long)this.range1.getMaximum()))));
        Assertions.assertEquals((long)15L, (Long)((Long)this.range1.fit((Object)15L)));
    }

    @Test
    void testFitNull() {
        LangAssertions.assertNullPointerException(() -> this.range1.fit(null));
    }

    @Test
    void testGetMaximum() {
        Assertions.assertEquals((long)20L, (Long)((Long)this.range1.getMaximum()));
    }

    @Test
    void testGetMinimum() {
        Assertions.assertEquals((long)10L, (Long)((Long)this.range1.getMinimum()));
    }

    @Test
    void testHashCode() {
        Assertions.assertEquals((int)this.range1.hashCode(), (int)this.range2.hashCode());
        Assertions.assertNotEquals((int)this.range1.hashCode(), (int)this.range3.hashCode());
        Assertions.assertEquals((int)this.range1.hashCode(), (int)this.range1.hashCode());
        Assertions.assertTrue((this.range1.hashCode() != 0 ? 1 : 0) != 0);
    }

    @Test
    void testIntersectionWith() {
        Assertions.assertSame((Object)this.range1, (Object)this.range1.intersectionWith((Range)this.range1));
        Assertions.assertEquals((Object)Range.of((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(15L)), (Object)this.range1.intersectionWith(Range.of((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(15L))));
    }

    @Test
    void testIntersectionWithNonOverlapping() {
        LangAssertions.assertIllegalArgumentException(() -> this.range1.intersectionWith(Range.of((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(9L))));
    }

    @Test
    void testIntersectionWithNull() {
        LangAssertions.assertIllegalArgumentException(() -> this.range1.intersectionWith(null));
    }

    @Test
    void testIsAfter() {
        Assertions.assertFalse((boolean)this.range1.isAfter(null));
        Assertions.assertTrue((boolean)this.range1.isAfter((Object)5L));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)10L));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)15L));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)20L));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)25L));
    }

    @Test
    void testIsAfterRange() {
        Assertions.assertFalse((boolean)this.range1.isAfterRange(null));
        Assertions.assertTrue((boolean)this.range1.isAfterRange(Range.of((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(9L))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(10L))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(20L))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(25L))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Long.valueOf(15L), (Comparable)Long.valueOf(25L))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Long.valueOf(21L), (Comparable)Long.valueOf(25L))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(20L))));
    }

    @Test
    void testIsBefore() {
        Assertions.assertFalse((boolean)this.range1.isBefore(null));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)5L));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)10L));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)15L));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)20L));
        Assertions.assertTrue((boolean)this.range1.isBefore((Object)25L));
    }

    @Test
    void testIsBeforeIntegerRange() {
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(null));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)LongRangeTest.of(5, 9)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)LongRangeTest.of(5, 10)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)LongRangeTest.of(5, 20)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)LongRangeTest.of(5, 25)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)LongRangeTest.of(15, 25)));
        Assertions.assertTrue((boolean)this.range1.isBeforeRange((Range)LongRangeTest.of(21, 25)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)LongRangeTest.of(10, 20)));
    }

    @Test
    void testIsBeforeRange() {
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(null));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(9L))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(10L))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(20L))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(25L))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Long.valueOf(15L), (Comparable)Long.valueOf(25L))));
        Assertions.assertTrue((boolean)this.range1.isBeforeRange(Range.of((Comparable)Long.valueOf(21L), (Comparable)Long.valueOf(25L))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(20L))));
    }

    @Test
    void testIsEndedBy() {
        Assertions.assertFalse((boolean)this.range1.isEndedBy(null));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)5L));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)10L));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)15L));
        Assertions.assertTrue((boolean)this.range1.isEndedBy((Object)20L));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)25L));
    }

    @Test
    void testIsOverlappedByIntegerRange() {
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(null));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(12, 18)));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(32, 45)));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(2, 8)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(10, 20)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(9, 14)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(16, 21)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(10, 19)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(10, 21)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(11, 20)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(9, 20)));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(-11, -18)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)LongRangeTest.of(9, 21)));
    }

    @Test
    void testIsOverlappedByRange() {
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(null));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(12L), (Comparable)Long.valueOf(18L))));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(32L), (Comparable)Long.valueOf(45L))));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(2L), (Comparable)Long.valueOf(8L))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(20L))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(9L), (Comparable)Long.valueOf(14L))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(16L), (Comparable)Long.valueOf(21L))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(19L))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(10L), (Comparable)Long.valueOf(21L))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(11L), (Comparable)Long.valueOf(20L))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(9L), (Comparable)Long.valueOf(20L))));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(-11L), (Comparable)Long.valueOf(-18L))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Long.valueOf(9L), (Comparable)Long.valueOf(21L))));
    }

    @Test
    void testIsStartedBy() {
        Assertions.assertFalse((boolean)this.range1.isStartedBy(null));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)5L));
        Assertions.assertTrue((boolean)this.range1.isStartedBy((Object)10L));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)15L));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)20L));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)25L));
    }

    @Test
    void testIsWithCompareRange() {
        Comparator c = (o1, o2) -> 0;
        Range ri = Range.is((Comparable)Integer.valueOf(10));
        Assertions.assertFalse((boolean)ri.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)ri.contains((Object)10), (String)"should contain 10");
        Assertions.assertFalse((boolean)ri.contains((Object)11), (String)"should not contain 11");
        ri = Range.is((Object)10, (Comparator)c);
        Assertions.assertFalse((boolean)ri.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)ri.contains((Object)10), (String)"should contain 10");
        Assertions.assertTrue((boolean)ri.contains((Object)11), (String)"should contain 11");
    }

    @Test
    void testOfWithContains() {
        LongRange rb = LongRangeTest.of(-10, 20);
        Assertions.assertFalse((boolean)rb.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rb.contains((Object)10L), (String)"should contain 10");
        Assertions.assertTrue((boolean)rb.contains((Object)-10L), (String)"should contain -10");
        Assertions.assertFalse((boolean)rb.contains((Object)21L), (String)"should not contain 21");
        Assertions.assertFalse((boolean)rb.contains((Object)-11L), (String)"should not contain -11");
        LangAssertions.assertNullPointerException(() -> LongRangeTest.of(null, null));
    }

    @Test
    void testRangeOfChars() {
        LongRange chars = LongRangeTest.of(97L, 122L);
        Assertions.assertTrue((boolean)chars.contains((Object)98L));
        Assertions.assertFalse((boolean)chars.contains((Object)66L));
    }

    @Test
    void testSerializing() {
        SerializationUtils.clone((Serializable)this.range1);
    }

    @Test
    void testToIntStream() {
        try (LongStream stream = this.range1.toLongStream();){
            Assertions.assertEquals((long)165L, (long)stream.sum());
        }
    }

    @Test
    void testToString() {
        Assertions.assertNotNull((Object)this.range1.toString());
        String str = this.range1.toString();
        Assertions.assertEquals((Object)"[10..20]", (Object)str);
        Assertions.assertEquals((Object)"[-20..-10]", (Object)Range.of((Comparable)Integer.valueOf(-20), (Comparable)Integer.valueOf(-10)).toString());
    }

    @Test
    void testToStringFormat() {
        String str = this.range1.toString("From %1$s to %2$s");
        Assertions.assertEquals((Object)"From 10 to 20", (Object)str);
    }
}

