/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;
import java.util.stream.IntStream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.IntegerRange;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class IntegerRangeTest
extends AbstractLangTest {
    private IntegerRange range1;
    private IntegerRange range2;
    private IntegerRange range3;
    private IntegerRange rangeFull;

    IntegerRangeTest() {
    }

    private static IntegerRange of(int min, int max) {
        return IntegerRange.of((int)min, (int)max);
    }

    private static IntegerRange of(Integer min, Integer max) {
        return IntegerRange.of((Integer)min, (Integer)max);
    }

    @BeforeEach
    public void setUp() {
        this.range1 = IntegerRangeTest.of(10, 20);
        this.range2 = IntegerRangeTest.of(10, 20);
        this.range3 = IntegerRangeTest.of(-2, -1);
        this.rangeFull = IntegerRangeTest.of(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Test
    void testContainsInt() {
        Assertions.assertFalse((boolean)this.range1.contains(null));
        Assertions.assertTrue((boolean)this.rangeFull.contains((Object)Integer.MIN_VALUE));
        Assertions.assertTrue((boolean)this.rangeFull.contains((Object)Integer.MAX_VALUE));
        Assertions.assertFalse((boolean)this.range1.contains((Object)5));
        Assertions.assertTrue((boolean)this.range1.contains((Object)10));
        Assertions.assertTrue((boolean)this.range1.contains((Object)15));
        Assertions.assertTrue((boolean)this.range1.contains((Object)20));
        Assertions.assertFalse((boolean)this.range1.contains((Object)25));
    }

    @Test
    void testContainsRange() {
        Assertions.assertFalse((boolean)this.range1.containsRange(null));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(18))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(12, 18)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(32), (Comparable)Integer.valueOf(45))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(32, 45)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(2, 8)));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(10, 20)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(14))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(9, 14)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(21))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(16, 21)));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(19))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(10, 19)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(21))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(10, 21)));
        Assertions.assertTrue((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(11), (Comparable)Integer.valueOf(20))));
        Assertions.assertTrue((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(11, 20)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(20))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(9, 20)));
        Assertions.assertFalse((boolean)this.range1.containsRange(Range.of((Comparable)Integer.valueOf(-11), (Comparable)Integer.valueOf(-18))));
        Assertions.assertFalse((boolean)this.range1.containsRange((Range)IntegerRangeTest.of(-11, -18)));
    }

    @Test
    void testElementCompareTo() {
        LangAssertions.assertNullPointerException(() -> this.range1.elementCompareTo(null));
        Assertions.assertEquals((int)-1, (int)this.range1.elementCompareTo((Object)5));
        Assertions.assertEquals((int)0, (int)this.range1.elementCompareTo((Object)10));
        Assertions.assertEquals((int)0, (int)this.range1.elementCompareTo((Object)15));
        Assertions.assertEquals((int)0, (int)this.range1.elementCompareTo((Object)20));
        Assertions.assertEquals((int)1, (int)this.range1.elementCompareTo((Object)25));
    }

    @Test
    void testEqualsObject() {
        Assertions.assertEquals((Object)this.range1, (Object)this.range1);
        Assertions.assertEquals((Object)this.range1, (Object)this.range2);
        Assertions.assertEquals((Object)this.range2, (Object)this.range2);
        Assertions.assertEquals((Object)this.range1, (Object)this.range1);
        Assertions.assertEquals((Object)this.range2, (Object)this.range2);
        Assertions.assertEquals((Object)this.range3, (Object)this.range3);
        Assertions.assertNotEquals((Object)this.range2, (Object)this.range3);
        Assertions.assertNotEquals(null, (Object)this.range2);
        Assertions.assertNotEquals((Object)"Ni!", (Object)this.range2);
    }

    @Test
    void testFit() {
        Assertions.assertEquals((Integer)((Integer)this.range1.getMinimum()), (Integer)((Integer)this.range1.fit((Object)Integer.MIN_VALUE)));
        Assertions.assertEquals((Integer)((Integer)this.range1.getMinimum()), (Integer)((Integer)this.range1.fit((Object)((Integer)this.range1.getMinimum()))));
        Assertions.assertEquals((Integer)((Integer)this.range1.getMaximum()), (Integer)((Integer)this.range1.fit((Object)Integer.MAX_VALUE)));
        Assertions.assertEquals((Integer)((Integer)this.range1.getMaximum()), (Integer)((Integer)this.range1.fit((Object)((Integer)this.range1.getMaximum()))));
        Assertions.assertEquals((int)15, (Integer)((Integer)this.range1.fit((Object)15)));
    }

    @Test
    void testFitNull() {
        LangAssertions.assertNullPointerException(() -> this.range1.fit(null));
    }

    @Test
    void testGetMaximum() {
        Assertions.assertEquals((int)20, (int)((Integer)this.range1.getMaximum()));
    }

    @Test
    void testGetMinimum() {
        Assertions.assertEquals((int)10, (int)((Integer)this.range1.getMinimum()));
    }

    @Test
    void testHashCode() {
        Assertions.assertEquals((int)this.range1.hashCode(), (int)this.range2.hashCode());
        Assertions.assertNotEquals((int)this.range1.hashCode(), (int)this.range3.hashCode());
        Assertions.assertEquals((int)this.range1.hashCode(), (int)this.range1.hashCode());
        Assertions.assertTrue((this.range1.hashCode() != 0 ? 1 : 0) != 0);
    }

    @Test
    void testIntersectionWith() {
        Assertions.assertSame((Object)this.range1, (Object)this.range1.intersectionWith((Range)this.range1));
        Assertions.assertEquals((Object)Range.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15)), (Object)this.range1.intersectionWith(Range.of((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(15))));
    }

    @Test
    void testIntersectionWithNonOverlapping() {
        LangAssertions.assertIllegalArgumentException(() -> this.range1.intersectionWith(Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(9))));
    }

    @Test
    void testIntersectionWithNull() {
        LangAssertions.assertIllegalArgumentException(() -> this.range1.intersectionWith(null));
    }

    @Test
    void testIsAfter() {
        Assertions.assertFalse((boolean)this.range1.isAfter(null));
        Assertions.assertTrue((boolean)this.range1.isAfter((Object)5));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)10));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)15));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)20));
        Assertions.assertFalse((boolean)this.range1.isAfter((Object)25));
    }

    @Test
    void testIsAfterRange() {
        Assertions.assertFalse((boolean)this.range1.isAfterRange(null));
        Assertions.assertTrue((boolean)this.range1.isAfterRange(Range.of((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(9))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(20))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(25))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(25))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(25))));
        Assertions.assertFalse((boolean)this.range1.isAfterRange(Range.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
    }

    @Test
    void testIsBefore() {
        Assertions.assertFalse((boolean)this.range1.isBefore(null));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)5));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)10));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)15));
        Assertions.assertFalse((boolean)this.range1.isBefore((Object)20));
        Assertions.assertTrue((boolean)this.range1.isBefore((Object)25));
    }

    @Test
    void testIsBeforeIntegerRange() {
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(null));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)IntegerRangeTest.of(5, 9)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)IntegerRangeTest.of(5, 10)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)IntegerRangeTest.of(5, 20)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)IntegerRangeTest.of(5, 25)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)IntegerRangeTest.of(15, 25)));
        Assertions.assertTrue((boolean)this.range1.isBeforeRange((Range)IntegerRangeTest.of(21, 25)));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange((Range)IntegerRangeTest.of(10, 20)));
    }

    @Test
    void testIsBeforeRange() {
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(null));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(9))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(10))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(20))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(25))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(25))));
        Assertions.assertTrue((boolean)this.range1.isBeforeRange(Range.of((Comparable)Integer.valueOf(21), (Comparable)Integer.valueOf(25))));
        Assertions.assertFalse((boolean)this.range1.isBeforeRange(Range.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
    }

    @Test
    void testIsEndedBy() {
        Assertions.assertFalse((boolean)this.range1.isEndedBy(null));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)5));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)10));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)15));
        Assertions.assertTrue((boolean)this.range1.isEndedBy((Object)20));
        Assertions.assertFalse((boolean)this.range1.isEndedBy((Object)25));
    }

    @Test
    void testIsOverlappedByIntegerRange() {
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(null));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(12, 18)));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(32, 45)));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(2, 8)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(10, 20)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(9, 14)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(16, 21)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(10, 19)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(10, 21)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(11, 20)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(9, 20)));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(-11, -18)));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy((Range)IntegerRangeTest.of(9, 21)));
    }

    @Test
    void testIsOverlappedByRange() {
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(null));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(18))));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(32), (Comparable)Integer.valueOf(45))));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(14))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(21))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(19))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(21))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(11), (Comparable)Integer.valueOf(20))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(20))));
        Assertions.assertFalse((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(-11), (Comparable)Integer.valueOf(-18))));
        Assertions.assertTrue((boolean)this.range1.isOverlappedBy(Range.of((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(21))));
    }

    @Test
    void testIsStartedBy() {
        Assertions.assertFalse((boolean)this.range1.isStartedBy(null));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)5));
        Assertions.assertTrue((boolean)this.range1.isStartedBy((Object)10));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)15));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)20));
        Assertions.assertFalse((boolean)this.range1.isStartedBy((Object)25));
    }

    @Test
    void testIsWithCompareRange() {
        Comparator c = (o1, o2) -> 0;
        Range ri = Range.is((Comparable)Integer.valueOf(10));
        Assertions.assertFalse((boolean)ri.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)ri.contains((Object)10), (String)"should contain 10");
        Assertions.assertFalse((boolean)ri.contains((Object)11), (String)"should not contain 11");
        ri = Range.is((Object)10, (Comparator)c);
        Assertions.assertFalse((boolean)ri.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)ri.contains((Object)10), (String)"should contain 10");
        Assertions.assertTrue((boolean)ri.contains((Object)11), (String)"should contain 11");
    }

    @Test
    void testOfWithContains() {
        IntegerRange rb = IntegerRangeTest.of(-10, 20);
        Assertions.assertFalse((boolean)rb.contains(null), (String)"should not contain null");
        Assertions.assertTrue((boolean)rb.contains((Object)10), (String)"should contain 10");
        Assertions.assertTrue((boolean)rb.contains((Object)-10), (String)"should contain -10");
        Assertions.assertFalse((boolean)rb.contains((Object)21), (String)"should not contain 21");
        Assertions.assertFalse((boolean)rb.contains((Object)-11), (String)"should not contain -11");
        LangAssertions.assertNullPointerException(() -> IntegerRangeTest.of(null, null));
    }

    @Test
    void testRangeOfChars() {
        IntegerRange chars = IntegerRangeTest.of(97, 122);
        Assertions.assertTrue((boolean)chars.contains((Object)98));
        Assertions.assertFalse((boolean)chars.contains((Object)66));
    }

    @Test
    void testSerializing() {
        SerializationUtils.clone((Serializable)this.range1);
    }

    @Test
    void testToIntStream() {
        try (IntStream stream = this.range1.toIntStream();){
            Assertions.assertEquals((int)165, (int)stream.sum());
        }
    }

    @Test
    void testToString() {
        Assertions.assertNotNull((Object)this.range1.toString());
        String str = this.range1.toString();
        Assertions.assertEquals((Object)"[10..20]", (Object)str);
        Assertions.assertEquals((Object)"[-20..-10]", (Object)Range.of((Comparable)Integer.valueOf(-20), (Comparable)Integer.valueOf(-10)).toString());
    }

    @Test
    void testToStringFormat() {
        String str = this.range1.toString("From %1$s to %2$s");
        Assertions.assertEquals((Object)"From 10 to 20", (Object)str);
    }
}

