/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcRecord;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcType;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcTypes;
import org.apache.commons.imaging.formats.jpeg.iptc.JpegIptcRewriter;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IptcFullDiscardTest {
    private byte[] addMetaData(byte[] bytes) throws Exception {
        IptcRecord record = new IptcRecord((IptcType)IptcTypes.KEYWORDS, "meta; data");
        PhotoshopApp13Data data = new PhotoshopApp13Data(Collections.singletonList(record), Collections.emptyList());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new JpegIptcRewriter().writeIptc(bytes, (OutputStream)byteArrayOutputStream, data);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] generateImage() throws Exception {
        BufferedImage image = new BufferedImage(100, 50, 5);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.drawString("Hello World!", 10, 10);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] removeMetaData(byte[] bytes, boolean removeApp13Segment) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new JpegIptcRewriter().removeIptc(bytes, (OutputStream)byteArrayOutputStream, removeApp13Segment);
        return byteArrayOutputStream.toByteArray();
    }

    @Test
    public void testLeaveApp13Segment() throws Exception {
        byte[] originalImage = this.generateImage();
        byte[] taggedImage = this.addMetaData(originalImage);
        byte[] untaggedImage = this.removeMetaData(taggedImage, false);
        Assertions.assertEquals((int)18, (int)(untaggedImage.length - originalImage.length));
    }

    @Test
    public void testRemoveApp13Segment() throws Exception {
        byte[] originalImage = this.generateImage();
        byte[] taggedImage = this.addMetaData(originalImage);
        byte[] untaggedImage = this.removeMetaData(taggedImage, true);
        Assertions.assertEquals((int)originalImage.length, (int)untaggedImage.length);
    }
}

