/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.convert.ValueTransformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDisabledListDelimiterHandler {
    private static final Object[] VALUES = new Object[]{20130630213801L, "A test value", 5};
    private static final String STR_VALUE = "  A test, string; value! ";
    private DisabledListDelimiterHandler handler;

    private static void checkIterator(Iterable<?> container) {
        Iterator<?> it = container.iterator();
        for (Object o : VALUES) {
            Assertions.assertEquals((Object)o, it.next());
        }
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.handler = new DisabledListDelimiterHandler();
    }

    @Test
    public void testEscapeList() {
        List<Object> values = Arrays.asList(VALUES);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.handler.escapeList(values, ListDelimiterHandler.NOOP_TRANSFORMER));
    }

    @Test
    public void testEscapeNonStringValue() {
        Integer value = 42;
        Assertions.assertEquals((Object)value, (Object)this.handler.escape((Object)value, ListDelimiterHandler.NOOP_TRANSFORMER));
    }

    @Test
    public void testEscapeNonStringValueTransformer() {
        ValueTransformer trans = (ValueTransformer)Mockito.mock(ValueTransformer.class);
        Integer value = 42;
        Mockito.when((Object)trans.transformValue((Object)value)).thenReturn((Object)STR_VALUE);
        Assertions.assertEquals((Object)STR_VALUE, (Object)this.handler.escape((Object)value, trans));
        ((ValueTransformer)Mockito.verify((Object)trans)).transformValue((Object)value);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{trans});
    }

    @Test
    public void testEscapeStringValue() {
        Assertions.assertEquals((Object)STR_VALUE, (Object)this.handler.escape((Object)STR_VALUE, ListDelimiterHandler.NOOP_TRANSFORMER));
    }

    @Test
    public void testEscapeStringValueTransformer() {
        ValueTransformer trans = (ValueTransformer)Mockito.mock(ValueTransformer.class);
        String testStr = "Some other string";
        Mockito.when((Object)trans.transformValue((Object)"Some other string")).thenReturn((Object)STR_VALUE);
        Assertions.assertEquals((Object)STR_VALUE, (Object)this.handler.escape((Object)"Some other string", trans));
        ((ValueTransformer)Mockito.verify((Object)trans)).transformValue((Object)"Some other string");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{trans});
    }

    @Test
    public void testFlattenArrayWithLimit() {
        Collection res = this.handler.flatten((Object)VALUES, 1);
        Assertions.assertEquals((int)1, (int)res.size());
        Assertions.assertEquals((Object)VALUES[0], res.iterator().next());
    }

    @Test
    public void testFlattenCollectionWithArrayWithLimit() {
        ArrayList<Object> src = new ArrayList<Object>(2);
        src.add(STR_VALUE);
        src.add(VALUES);
        Collection res = this.handler.flatten(src, 2);
        Assertions.assertEquals((int)2, (int)res.size());
        Iterator it = res.iterator();
        Assertions.assertEquals((Object)STR_VALUE, it.next());
        Assertions.assertEquals((Object)VALUES[0], it.next());
    }

    @Test
    public void testFlattenCollectionWithLimit() {
        List<Object> src = Arrays.asList(VALUES);
        Collection res = this.handler.flatten(src, 1);
        Assertions.assertEquals((int)1, (int)res.size());
        Assertions.assertEquals((Object)VALUES[0], res.iterator().next());
    }

    @Test
    public void testParseArray() {
        TestDisabledListDelimiterHandler.checkIterator(this.handler.parse((Object)VALUES));
    }

    @Test
    public void testParseIterable() {
        TestDisabledListDelimiterHandler.checkIterator(this.handler.parse(Arrays.asList(VALUES)));
    }

    @Test
    public void testParseIterator() {
        TestDisabledListDelimiterHandler.checkIterator(this.handler.parse(Arrays.asList(VALUES).iterator()));
    }

    @Test
    public void testParseNull() {
        Assertions.assertFalse((boolean)this.handler.parse(null).iterator().hasNext());
    }

    @Test
    public void testParseSimpleValue() {
        Iterator it = this.handler.parse((Object)STR_VALUE).iterator();
        Assertions.assertEquals((Object)STR_VALUE, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }
}

