/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodeIteratorAttribute;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConfigurationIteratorAttributes
extends AbstractXPathTest {
    private static final String TEST_ATTR = "test";
    private static final String NAMESPACE = "commons";
    private static final String NS_ATTR = "commons:attr";
    private ConfigurationNodePointer<ImmutableNode> pointer;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ImmutableNode orgNode = (ImmutableNode)this.root.getChildren().get(1);
        ImmutableNode testNode = orgNode.setAttribute(TEST_ATTR, (Object)"yes").setAttribute(NS_ATTR, (Object)"configuration");
        this.pointer = new ConfigurationNodePointer((Object)testNode, Locale.getDefault(), this.handler);
    }

    @Test
    public void testIterateAllAttributes() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(null, "*"));
        Assertions.assertEquals((int)3, (int)this.iteratorSize((NodeIterator)it));
        List<NodePointer> attrs = this.iterationElements((NodeIterator)it);
        HashSet<String> attrNames = new HashSet<String>();
        for (NodePointer np : attrs) {
            attrNames.add(np.getName().getName());
        }
        Assertions.assertTrue((boolean)attrNames.contains("counter"));
        Assertions.assertTrue((boolean)attrNames.contains(TEST_ATTR));
        Assertions.assertTrue((boolean)attrNames.contains(NS_ATTR));
    }

    @Test
    public void testIterateNamespaceAttribute() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(NAMESPACE, "attr"));
        Assertions.assertEquals((int)1, (int)this.iteratorSize((NodeIterator)it));
        Assertions.assertEquals((Object)NS_ATTR, (Object)this.iterationElements((NodeIterator)it).get(0).getName().getName());
    }

    @Test
    public void testIterateNamespaceUnknown() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(TEST_ATTR, "*"));
        Assertions.assertEquals((int)0, (int)this.iteratorSize((NodeIterator)it));
    }

    @Test
    public void testIterateNamespaceWildcard() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(NAMESPACE, "*"));
        Assertions.assertEquals((int)1, (int)this.iteratorSize((NodeIterator)it));
        Assertions.assertEquals((Object)NS_ATTR, (Object)this.iterationElements((NodeIterator)it).get(0).getName().getName());
    }

    @Test
    public void testIterateSpecificAttribute() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(null, TEST_ATTR));
        Assertions.assertEquals((int)1, (int)this.iteratorSize((NodeIterator)it));
        Assertions.assertEquals((Object)TEST_ATTR, (Object)this.iterationElements((NodeIterator)it).get(0).getName().getName());
    }

    @Test
    public void testIterateUnknownAttribute() {
        ConfigurationNodeIteratorAttribute it = new ConfigurationNodeIteratorAttribute(this.pointer, new QName(null, "unknown"));
        Assertions.assertEquals((int)0, (int)this.iteratorSize((NodeIterator)it));
    }
}

