/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.beanutils.ConfigurationDynaBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConfigurationDynaBean {
    private ConfigurationDynaBean bean;
    private final String[] properties = new String[]{"booleanProperty", "booleanSecond", "doubleProperty", "floatProperty", "intProperty", "longProperty", "mappedProperty.key1", "mappedProperty.key2", "mappedProperty.key3", "mappedIntProperty.key1", "shortProperty", "stringProperty", "byteProperty", "charProperty"};
    private final Object[] values = new Object[]{Boolean.TRUE, Boolean.TRUE, Double.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), Integer.MAX_VALUE, Long.MAX_VALUE, "First Value", "Second Value", "Third Value", Integer.MAX_VALUE, (short)Short.MAX_VALUE, "This is a string", (byte)127, Character.valueOf('\uffff')};
    private final int[] intArray = new int[]{0, 10, 20, 30, 40};
    private final boolean[] booleanArray = new boolean[]{true, false, true, false, true};
    private final char[] charArray = new char[]{'a', 'b', 'c', 'd', 'e'};
    private final byte[] byteArray = new byte[]{0, 10, 20, 30, 40};
    private final long[] longArray = new long[]{0L, 10L, 20L, 30L, 40L};
    private final short[] shortArray = new short[]{0, 10, 20, 30, 40};
    private final float[] floatArray = new float[]{0.0f, 10.0f, 20.0f, 30.0f, 40.0f};
    private final double[] doubleArray = new double[]{0.0, 10.0, 20.0, 30.0, 40.0};
    private final String[] stringArray = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};

    protected Configuration createConfiguration() {
        return new BaseConfiguration();
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() throws Exception {
        void var2_3;
        Configuration configuration = this.createConfiguration();
        boolean bl = false;
        while (var2_3 < this.properties.length) {
            configuration.setProperty(this.properties[var2_3], this.values[var2_3]);
            ++var2_3;
        }
        for (int element : this.intArray) {
            configuration.addProperty("intIndexed", (Object)element);
        }
        for (String element : this.stringArray) {
            configuration.addProperty("stringIndexed", (Object)element);
        }
        List<String> list = Arrays.asList(this.stringArray);
        configuration.addProperty("listIndexed", list);
        this.bean = new ConfigurationDynaBean(configuration);
        this.bean.set("listIndexed", list);
        this.bean.set("intArray", (Object)this.intArray);
        this.bean.set("booleanArray", (Object)this.booleanArray);
        this.bean.set("charArray", (Object)this.charArray);
        this.bean.set("longArray", (Object)this.longArray);
        this.bean.set("shortArray", (Object)this.shortArray);
        this.bean.set("floatArray", (Object)this.floatArray);
        this.bean.set("doubleArray", (Object)this.doubleArray);
        this.bean.set("byteArray", (Object)this.byteArray);
        this.bean.set("stringArray", (Object)this.stringArray);
    }

    @Test
    public void testAddNullPropertyValue() {
        Assertions.assertThrows(NullPointerException.class, () -> this.bean.set("nullProperty", null));
    }

    @Test
    public void testGetDescriptorArguments() {
        DynaProperty descriptor = this.bean.getDynaClass().getDynaProperty("unknown");
        Assertions.assertNull((Object)descriptor);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.getDynaClass().getDynaProperty(null));
    }

    protected void testGetDescriptorBase(String name, Class<?> type) {
        DynaProperty descriptor = this.bean.getDynaClass().getDynaProperty(name);
        Assertions.assertNotNull((Object)descriptor);
        Assertions.assertEquals(type, (Object)descriptor.getType());
    }

    @Test
    public void testGetDescriptorBoolean() {
        this.testGetDescriptorBase("booleanProperty", Boolean.TYPE);
    }

    @Test
    public void testGetDescriptorDouble() {
        this.testGetDescriptorBase("doubleProperty", Double.TYPE);
    }

    @Test
    public void testGetDescriptorFloat() {
        this.testGetDescriptorBase("floatProperty", Float.TYPE);
    }

    @Test
    public void testGetDescriptorInt() {
        this.testGetDescriptorBase("intProperty", Integer.TYPE);
    }

    @Test
    public void testGetDescriptorLong() {
        this.testGetDescriptorBase("longProperty", Long.TYPE);
    }

    @Test
    public void testGetDescriptors() {
        DynaProperty[] pd = this.bean.getDynaClass().getDynaProperties();
        Assertions.assertNotNull((Object)pd);
        int[] count = new int[this.properties.length];
        for (DynaProperty element : pd) {
            String name = element.getName();
            for (int j = 0; j < this.properties.length; ++j) {
                if (!name.equals(this.properties[j])) continue;
                int n = j;
                count[n] = count[n] + 1;
            }
        }
        for (int j = 0; j < this.properties.length; ++j) {
            Assertions.assertFalse((count[j] < 0 ? 1 : 0) != 0, (String)("Missing property " + this.properties[j]));
            Assertions.assertFalse((count[j] > 1 ? 1 : 0) != 0, (String)("Duplicate property " + this.properties[j]));
        }
    }

    @Test
    public void testGetDescriptorSecond() {
        this.testGetDescriptorBase("booleanSecond", Boolean.TYPE);
    }

    @Test
    public void testGetDescriptorShort() {
        this.testGetDescriptorBase("shortProperty", Short.TYPE);
    }

    @Test
    public void testGetDescriptorString() {
        this.testGetDescriptorBase("stringProperty", String.class);
    }

    @Test
    public void testGetIndexedArguments() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.bean.get("intArray", -1));
    }

    @Test
    public void testGetIndexedNonExisting() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.get("Non existing property", 0));
    }

    @Test
    public void testGetIndexedString() {
        this.bean.set("stringProp", (Object)"value");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.get("stringProp", 0));
    }

    @Test
    public void testGetIndexedValues() {
        for (int i = 0; i < 5; ++i) {
            Object value = this.bean.get("intArray", i);
            int intValue = (Integer)Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intArray index " + i));
            Assertions.assertEquals((int)(i * 10), (int)intValue, (String)("intArray " + i));
            value = this.bean.get("intIndexed", i);
            intValue = (Integer)Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intIndexed index " + i));
            Assertions.assertEquals((int)(i * 10), (int)intValue, (String)("intIndexed index " + i));
            value = this.bean.get("listIndexed", i);
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("list index " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)value, (String)("listIndexed index " + i));
            value = this.bean.get("stringArray", i);
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringArray index " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)value, (String)("stringArray index " + i));
            value = this.bean.get("stringIndexed", i);
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringIndexed index " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)value, (String)("stringIndexed index " + i));
        }
    }

    @Test
    public void testGetMappedArguments() {
        Object value = this.bean.get("mappedProperty", "unknown");
        Assertions.assertNull((Object)value);
    }

    @Test
    public void testGetMappedValues() {
        Object value = this.bean.get("mappedProperty", "key1");
        Assertions.assertEquals((Object)"First Value", (Object)value);
        value = this.bean.get("mappedProperty", "key2");
        Assertions.assertEquals((Object)"Second Value", (Object)value);
        value = this.bean.get("mappedProperty", "key3");
        Assertions.assertNotNull((Object)value);
    }

    @Test
    public void testGetNonExistentProperty() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.get("nonexistProperty"));
    }

    @Test
    public void testGetNonIndexedProperties() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.get("booleanProperty", 0));
    }

    @Test
    public void testGetSimpleArguments() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.get("a non existing property"));
    }

    @Test
    public void testGetSimpleBoolean() {
        Object value = this.bean.get("booleanProperty");
        Assertions.assertInstanceOf(Boolean.class, (Object)value);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)value);
    }

    @Test
    public void testGetSimpleDouble() {
        Object value = this.bean.get("doubleProperty");
        double doubleValue = (Double)Assertions.assertInstanceOf(Double.class, (Object)value);
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)doubleValue, (double)0.005);
    }

    @Test
    public void testGetSimpleFloat() {
        Object value = this.bean.get("floatProperty");
        float floatValue = ((Float)Assertions.assertInstanceOf(Float.class, (Object)value)).floatValue();
        Assertions.assertEquals((float)Float.MAX_VALUE, (float)floatValue, (float)0.005f);
    }

    @Test
    public void testGetSimpleInt() {
        Object value = this.bean.get("intProperty");
        int intValue = (Integer)Assertions.assertInstanceOf(Integer.class, (Object)value);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)intValue);
    }

    @Test
    public void testGetSimpleLong() {
        Object value = this.bean.get("longProperty");
        long longValue = (Long)Assertions.assertInstanceOf(Long.class, (Object)value);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)longValue);
    }

    @Test
    public void testGetSimpleShort() {
        Object value = this.bean.get("shortProperty");
        short shortValue = (Short)Assertions.assertInstanceOf(Short.class, (Object)value);
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)shortValue);
    }

    @Test
    public void testGetSimpleString() {
        Object value = this.bean.get("stringProperty");
        Assertions.assertInstanceOf(String.class, (Object)value);
        Assertions.assertEquals((Object)"This is a string", (Object)value);
    }

    @Test
    public void testMappedContains() {
        Assertions.assertTrue((boolean)this.bean.contains("mappedProperty", "key1"));
        Assertions.assertFalse((boolean)this.bean.contains("mappedProperty", "Unknown Key"));
    }

    @Test
    public void testMappedRemove() {
        Assertions.assertTrue((boolean)this.bean.contains("mappedProperty", "key1"));
        this.bean.remove("mappedProperty", "key1");
        Assertions.assertFalse((boolean)this.bean.contains("mappedProperty", "key1"));
        Assertions.assertFalse((boolean)this.bean.contains("mappedProperty", "key4"));
        this.bean.remove("mappedProperty", "key4");
        Assertions.assertFalse((boolean)this.bean.contains("mappedProperty", "key4"));
    }

    @Test
    public void testNestedPropeties() {
        ConfigurationDynaBean nested = (ConfigurationDynaBean)this.bean.get("mappedProperty");
        String value = (String)nested.get("key1");
        Assertions.assertEquals((Object)"First Value", (Object)value);
        nested.set("key1", (Object)"undefined");
        Assertions.assertEquals((Object)"undefined", (Object)this.bean.get("mappedProperty.key1"));
    }

    @Test
    public void testSetArrayValue() {
        MapConfiguration configuration = new MapConfiguration(new HashMap());
        configuration.getMap().put("objectArray", new Object[]{"value1", "value2", "value3"});
        ConfigurationDynaBean bean = new ConfigurationDynaBean((Configuration)configuration);
        bean.set("objectArray", 1, (Object)"New Value 1");
        Object value = bean.get("objectArray", 1);
        Assertions.assertInstanceOf(String.class, (Object)value);
        Assertions.assertEquals((Object)"New Value 1", (Object)value);
    }

    @Test
    public void testSetIndexedArguments() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.bean.set("intArray", -1, (Object)0));
    }

    @Test
    public void testSetIndexedValues() {
        this.bean.set("intArray", 0, (Object)1);
        Object value = this.bean.get("intArray", 0);
        int intValue = (Integer)Assertions.assertInstanceOf(Integer.class, (Object)value);
        Assertions.assertEquals((int)1, (int)intValue);
        this.bean.set("intIndexed", 1, (Object)11);
        value = this.bean.get("intIndexed", 1);
        intValue = (Integer)Assertions.assertInstanceOf(Integer.class, (Object)value);
        Assertions.assertEquals((int)11, (int)intValue);
        this.bean.set("listIndexed", 2, (Object)"New Value 2");
        value = this.bean.get("listIndexed", 2);
        Assertions.assertInstanceOf(String.class, (Object)value);
        Assertions.assertEquals((Object)"New Value 2", (Object)value);
        this.bean.set("stringArray", 3, (Object)"New Value 3");
        value = this.bean.get("stringArray", 3);
        Assertions.assertInstanceOf(String.class, (Object)value);
        Assertions.assertEquals((Object)"New Value 3", (Object)value);
        this.bean.set("stringIndexed", 4, (Object)"New Value 4");
        value = this.bean.get("stringIndexed", 4);
        Assertions.assertInstanceOf(String.class, (Object)value);
        Assertions.assertEquals((Object)"New Value 4", (Object)value);
    }

    @Test
    public void testSetMappedValues() {
        this.bean.set("mappedProperty", "First Key", (Object)"New First Value");
        Assertions.assertEquals((Object)"New First Value", (Object)this.bean.get("mappedProperty", "First Key"));
        this.bean.set("mappedProperty", "Fourth Key", (Object)"Fourth Value");
        Assertions.assertEquals((Object)"Fourth Value", (Object)this.bean.get("mappedProperty", "Fourth Key"));
    }

    @Test
    public void testSetNonIndexedProperties() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.set("booleanProperty", 1, (Object)Boolean.TRUE));
    }

    @Test
    public void testSetSimpleBoolean() {
        boolean oldValue = (Boolean)this.bean.get("booleanProperty");
        boolean newValue = !oldValue;
        this.bean.set("booleanProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)((Boolean)this.bean.get("booleanProperty")));
    }

    @Test
    public void testSetSimpleDouble() {
        double oldValue = (Double)this.bean.get("doubleProperty");
        double newValue = oldValue + 1.0;
        this.bean.set("doubleProperty", (Object)newValue);
        Assertions.assertEquals((double)newValue, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
    }

    @Test
    public void testSetSimpleFloat() {
        float oldValue = ((Float)this.bean.get("floatProperty")).floatValue();
        float newValue = oldValue + 1.0f;
        this.bean.set("floatProperty", (Object)Float.valueOf(newValue));
        Assertions.assertEquals((float)newValue, (float)((Float)this.bean.get("floatProperty")).floatValue(), (float)0.005f);
    }

    @Test
    public void testSetSimpleInt() {
        int oldValue = (Integer)this.bean.get("intProperty");
        int newValue = oldValue + 1;
        this.bean.set("intProperty", (Object)newValue);
        Assertions.assertEquals((int)newValue, (int)((Integer)this.bean.get("intProperty")));
    }

    @Test
    public void testSetSimpleLong() {
        long oldValue = (Long)this.bean.get("longProperty");
        long newValue = oldValue + 1L;
        this.bean.set("longProperty", (Object)newValue);
        Assertions.assertEquals((long)newValue, (long)((Long)this.bean.get("longProperty")));
    }

    @Test
    public void testSetSimpleShort() {
        short oldValue = (Short)this.bean.get("shortProperty");
        short newValue = (short)(oldValue + 1);
        this.bean.set("shortProperty", (Object)newValue);
        Assertions.assertEquals((short)newValue, (short)((Short)this.bean.get("shortProperty")));
    }

    @Test
    public void testSetSimpleString() {
        String oldValue = (String)this.bean.get("stringProperty");
        String newValue = oldValue + " Extra Value";
        this.bean.set("stringProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)this.bean.get("stringProperty"));
    }
}

