/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import jakarta.mail.internet.InternetAddress;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.DataConfiguration;
import org.apache.commons.configuration2.convert.ConversionHandler;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConversionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDataConfiguration {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private DataConfiguration conf;

    private static Date expectedDate() throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        return format.parse("2004-01-01");
    }

    @BeforeEach
    public void setUp() throws Exception {
        BaseConfiguration baseConfig = new BaseConfiguration();
        baseConfig.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        this.conf = new DataConfiguration((Configuration)baseConfig);
        this.conf.addProperty("empty", (Object)"");
        this.conf.addProperty("boolean.list1", (Object)"true");
        this.conf.addProperty("boolean.list1", (Object)"false");
        this.conf.addProperty("boolean.list2", (Object)"true, false");
        this.conf.addProperty("boolean.list3", (Object)Boolean.TRUE);
        this.conf.addProperty("boolean.list3", (Object)Boolean.FALSE);
        this.conf.addPropertyDirect("boolean.list4", (Object)new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        this.conf.addPropertyDirect("boolean.list5", (Object)new boolean[]{true, false});
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        booleans.add(Boolean.TRUE);
        booleans.add(Boolean.FALSE);
        this.conf.addProperty("boolean.list6", booleans);
        this.conf.addProperty("boolean.string", (Object)"true");
        this.conf.addProperty("boolean.object", (Object)Boolean.TRUE);
        this.conf.addProperty("boolean.list.interpolated", (Object)"${boolean.string},false");
        this.conf.addProperty("byte.list1", (Object)"1");
        this.conf.addProperty("byte.list1", (Object)"2");
        this.conf.addProperty("byte.list2", (Object)"1, 2");
        this.conf.addProperty("byte.list3", (Object)Byte.valueOf("1"));
        this.conf.addProperty("byte.list3", (Object)Byte.valueOf("2"));
        this.conf.addPropertyDirect("byte.list4", (Object)new Byte[]{Byte.valueOf("1"), Byte.valueOf("2")});
        this.conf.addPropertyDirect("byte.list5", (Object)new byte[]{1, 2});
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.add(Byte.valueOf("1"));
        bytes.add(Byte.valueOf("2"));
        this.conf.addProperty("byte.list6", bytes);
        this.conf.addProperty("byte.string", (Object)"1");
        this.conf.addProperty("byte.object", (Object)Byte.valueOf("1"));
        this.conf.addProperty("byte.list.interpolated", (Object)"${byte.string},2");
        this.conf.addProperty("short.list1", (Object)"1");
        this.conf.addProperty("short.list1", (Object)"2");
        this.conf.addProperty("short.list2", (Object)"1, 2");
        this.conf.addProperty("short.list3", (Object)Short.valueOf("1"));
        this.conf.addProperty("short.list3", (Object)Short.valueOf("2"));
        this.conf.addPropertyDirect("short.list4", (Object)new Short[]{Short.valueOf("1"), Short.valueOf("2")});
        this.conf.addPropertyDirect("short.list5", (Object)new short[]{1, 2});
        ArrayList<Short> shorts = new ArrayList<Short>();
        shorts.add(Short.valueOf("1"));
        shorts.add(Short.valueOf("2"));
        this.conf.addProperty("short.list6", shorts);
        this.conf.addProperty("short.string", (Object)"1");
        this.conf.addProperty("short.object", (Object)Short.valueOf("1"));
        this.conf.addProperty("short.list.interpolated", (Object)"${short.string},2");
        this.conf.addProperty("integer.list1", (Object)"1");
        this.conf.addProperty("integer.list1", (Object)"2");
        this.conf.addProperty("integer.list2", (Object)"1, 2");
        this.conf.addProperty("integer.list3", (Object)Integer.valueOf("1"));
        this.conf.addProperty("integer.list3", (Object)Integer.valueOf("2"));
        this.conf.addPropertyDirect("integer.list4", (Object)new Integer[]{Integer.valueOf("1"), Integer.valueOf("2")});
        this.conf.addPropertyDirect("integer.list5", (Object)new int[]{1, 2});
        ArrayList<Integer> integers = new ArrayList<Integer>();
        integers.add(Integer.valueOf("1"));
        integers.add(Integer.valueOf("2"));
        this.conf.addProperty("integer.list6", integers);
        this.conf.addProperty("integer.string", (Object)"1");
        this.conf.addProperty("integer.object", (Object)Integer.valueOf("1"));
        this.conf.addProperty("integer.list.interpolated", (Object)"${integer.string},2");
        this.conf.addProperty("long.list1", (Object)"1");
        this.conf.addProperty("long.list1", (Object)"2");
        this.conf.addProperty("long.list2", (Object)"1, 2");
        this.conf.addProperty("long.list3", (Object)Long.valueOf("1"));
        this.conf.addProperty("long.list3", (Object)Long.valueOf("2"));
        this.conf.addPropertyDirect("long.list4", (Object)new Long[]{Long.valueOf("1"), Long.valueOf("2")});
        this.conf.addPropertyDirect("long.list5", (Object)new long[]{1L, 2L});
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(Long.valueOf("1"));
        longs.add(Long.valueOf("2"));
        this.conf.addProperty("long.list6", longs);
        this.conf.addProperty("long.string", (Object)"1");
        this.conf.addProperty("long.object", (Object)Long.valueOf("1"));
        this.conf.addProperty("long.list.interpolated", (Object)"${long.string},2");
        this.conf.addProperty("float.list1", (Object)"1");
        this.conf.addProperty("float.list1", (Object)"2");
        this.conf.addProperty("float.list2", (Object)"1, 2");
        this.conf.addProperty("float.list3", (Object)Float.valueOf("1"));
        this.conf.addProperty("float.list3", (Object)Float.valueOf("2"));
        this.conf.addPropertyDirect("float.list4", (Object)new Float[]{Float.valueOf("1"), Float.valueOf("2")});
        this.conf.addPropertyDirect("float.list5", (Object)new float[]{1.0f, 2.0f});
        ArrayList<Float> floats = new ArrayList<Float>();
        floats.add(Float.valueOf("1"));
        floats.add(Float.valueOf("2"));
        this.conf.addProperty("float.list6", floats);
        this.conf.addProperty("float.string", (Object)"1");
        this.conf.addProperty("float.object", (Object)Float.valueOf("1"));
        this.conf.addProperty("float.list.interpolated", (Object)"${float.string},2");
        this.conf.addProperty("double.list1", (Object)"1");
        this.conf.addProperty("double.list1", (Object)"2");
        this.conf.addProperty("double.list2", (Object)"1, 2");
        this.conf.addProperty("double.list3", (Object)Double.valueOf("1"));
        this.conf.addProperty("double.list3", (Object)Double.valueOf("2"));
        this.conf.addPropertyDirect("double.list4", (Object)new Double[]{Double.valueOf("1"), Double.valueOf("2")});
        this.conf.addPropertyDirect("double.list5", (Object)new double[]{1.0, 2.0});
        ArrayList<Double> doubles = new ArrayList<Double>();
        doubles.add(Double.valueOf("1"));
        doubles.add(Double.valueOf("2"));
        this.conf.addProperty("double.list6", doubles);
        this.conf.addProperty("double.string", (Object)"1");
        this.conf.addProperty("double.object", (Object)Double.valueOf("1"));
        this.conf.addProperty("double.list.interpolated", (Object)"${double.string},2");
        this.conf.addProperty("biginteger.list1", (Object)"1");
        this.conf.addProperty("biginteger.list1", (Object)"2");
        this.conf.addProperty("biginteger.list2", (Object)"1, 2");
        this.conf.addProperty("biginteger.list3", (Object)new BigInteger("1"));
        this.conf.addProperty("biginteger.list3", (Object)new BigInteger("2"));
        this.conf.addPropertyDirect("biginteger.list4", (Object)new BigInteger[]{new BigInteger("1"), new BigInteger("2")});
        ArrayList<BigInteger> bigintegers = new ArrayList<BigInteger>();
        bigintegers.add(new BigInteger("1"));
        bigintegers.add(new BigInteger("2"));
        this.conf.addProperty("biginteger.list6", bigintegers);
        this.conf.addProperty("biginteger.string", (Object)"1");
        this.conf.addProperty("biginteger.object", (Object)new BigInteger("1"));
        this.conf.addProperty("biginteger.list.interpolated", (Object)"${biginteger.string},2");
        this.conf.addProperty("bigdecimal.list1", (Object)"1");
        this.conf.addProperty("bigdecimal.list1", (Object)"2");
        this.conf.addProperty("bigdecimal.list2", (Object)"1, 2");
        this.conf.addProperty("bigdecimal.list3", (Object)new BigDecimal("1"));
        this.conf.addProperty("bigdecimal.list3", (Object)new BigDecimal("2"));
        this.conf.addPropertyDirect("bigdecimal.list4", (Object)new BigDecimal[]{new BigDecimal("1"), new BigDecimal("2")});
        ArrayList<BigDecimal> bigdecimals = new ArrayList<BigDecimal>();
        bigdecimals.add(new BigDecimal("1"));
        bigdecimals.add(new BigDecimal("2"));
        this.conf.addProperty("bigdecimal.list6", bigdecimals);
        this.conf.addProperty("bigdecimal.string", (Object)"1");
        this.conf.addProperty("bigdecimal.object", (Object)new BigDecimal("1"));
        this.conf.addProperty("bigdecimal.list.interpolated", (Object)"${bigdecimal.string},2");
        String uri1 = "http://jakarta.apache.org";
        String uri2 = "http://www.apache.org";
        this.conf.addProperty("uri.string", (Object)"http://jakarta.apache.org");
        this.conf.addProperty("uri.string.interpolated", (Object)"${uri.string}");
        this.conf.addProperty("uri.object", (Object)new URI("http://jakarta.apache.org"));
        this.conf.addProperty("uri.list1", (Object)"http://jakarta.apache.org");
        this.conf.addProperty("uri.list1", (Object)"http://www.apache.org");
        this.conf.addProperty("uri.list2", (Object)"http://jakarta.apache.org, http://www.apache.org");
        this.conf.addProperty("uri.list3", (Object)new URI("http://jakarta.apache.org"));
        this.conf.addProperty("uri.list3", (Object)new URI("http://www.apache.org"));
        this.conf.addPropertyDirect("uri.list4", (Object)new URI[]{new URI("http://jakarta.apache.org"), new URI("http://www.apache.org")});
        ArrayList<URI> uris = new ArrayList<URI>();
        uris.add(new URI("http://jakarta.apache.org"));
        uris.add(new URI("http://www.apache.org"));
        this.conf.addProperty("uri.list6", uris);
        this.conf.addProperty("uri.list.interpolated", (Object)"${uri.string},http://www.apache.org");
        String url1 = "http://jakarta.apache.org";
        String url2 = "http://www.apache.org";
        this.conf.addProperty("url.string", (Object)"http://jakarta.apache.org");
        this.conf.addProperty("url.string.interpolated", (Object)"${url.string}");
        this.conf.addProperty("url.object", (Object)new URL("http://jakarta.apache.org"));
        this.conf.addProperty("url.list1", (Object)"http://jakarta.apache.org");
        this.conf.addProperty("url.list1", (Object)"http://www.apache.org");
        this.conf.addProperty("url.list2", (Object)"http://jakarta.apache.org, http://www.apache.org");
        this.conf.addProperty("url.list3", (Object)new URL("http://jakarta.apache.org"));
        this.conf.addProperty("url.list3", (Object)new URL("http://www.apache.org"));
        this.conf.addPropertyDirect("url.list4", (Object)new URL[]{new URL("http://jakarta.apache.org"), new URL("http://www.apache.org")});
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new URL("http://jakarta.apache.org"));
        urls.add(new URL("http://www.apache.org"));
        this.conf.addProperty("url.list6", urls);
        this.conf.addProperty("url.list.interpolated", (Object)"${url.string},http://www.apache.org");
        this.conf.addProperty("locale.string", (Object)"fr");
        this.conf.addProperty("locale.string.interpolated", (Object)"${locale.string}");
        this.conf.addProperty("locale.object", (Object)Locale.FRENCH);
        this.conf.addProperty("locale.list1", (Object)"fr");
        this.conf.addProperty("locale.list1", (Object)"de");
        this.conf.addProperty("locale.list2", (Object)"fr, de");
        this.conf.addProperty("locale.list3", (Object)Locale.FRENCH);
        this.conf.addProperty("locale.list3", (Object)Locale.GERMAN);
        this.conf.addPropertyDirect("locale.list4", (Object)new Locale[]{Locale.FRENCH, Locale.GERMAN});
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(Locale.FRENCH);
        locales.add(Locale.GERMAN);
        this.conf.addProperty("locale.list6", locales);
        this.conf.addProperty("locale.list.interpolated", (Object)"${locale.string},de");
        String color1 = "FF0000";
        String color2 = "0000FF";
        this.conf.addProperty("color.string", (Object)"FF0000");
        this.conf.addProperty("color.string.interpolated", (Object)"${color.string}");
        this.conf.addProperty("color.object", (Object)Color.red);
        this.conf.addProperty("color.list1", (Object)"FF0000");
        this.conf.addProperty("color.list1", (Object)"0000FF");
        this.conf.addProperty("color.list2", (Object)"FF0000, 0000FF");
        this.conf.addProperty("color.list3", (Object)Color.red);
        this.conf.addProperty("color.list3", (Object)Color.blue);
        this.conf.addPropertyDirect("color.list4", (Object)new Color[]{Color.red, Color.blue});
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.red);
        colors.add(Color.blue);
        this.conf.addProperty("color.list6", colors);
        this.conf.addProperty("color.list.interpolated", (Object)"${color.string},0000FF");
        String pattern = DATE_PATTERN;
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        this.conf.setProperty("org.apache.commons.configuration.format.date", (Object)DATE_PATTERN);
        Date date1 = format.parse("2004-01-01");
        Date date2 = format.parse("2004-12-31");
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        this.conf.addProperty("date.string", (Object)"2004-01-01");
        this.conf.addProperty("date.string.interpolated", (Object)"${date.string}");
        this.conf.addProperty("date.object", (Object)date1);
        this.conf.addProperty("date.list1", (Object)"2004-01-01");
        this.conf.addProperty("date.list1", (Object)"2004-12-31");
        this.conf.addProperty("date.list2", (Object)"2004-01-01, 2004-12-31");
        this.conf.addProperty("date.list3", (Object)date1);
        this.conf.addProperty("date.list3", (Object)date2);
        this.conf.addPropertyDirect("date.list4", (Object)new Date[]{date1, date2});
        this.conf.addPropertyDirect("date.list5", (Object)new Calendar[]{calendar1, calendar2});
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(date1);
        dates.add(date2);
        this.conf.addProperty("date.list6", dates);
        this.conf.addProperty("date.list.interpolated", (Object)"${date.string},2004-12-31");
        this.conf.addPropertyDirect("date.list7", (Object)new String[]{"2004-01-01", "2004-12-31"});
        this.conf.addProperty("calendar.string", (Object)"2004-01-01");
        this.conf.addProperty("calendar.string.interpolated", (Object)"${calendar.string}");
        this.conf.addProperty("calendar.object", (Object)calendar1);
        this.conf.addProperty("calendar.list1", (Object)"2004-01-01");
        this.conf.addProperty("calendar.list1", (Object)"2004-12-31");
        this.conf.addProperty("calendar.list2", (Object)"2004-01-01, 2004-12-31");
        this.conf.addProperty("calendar.list3", (Object)calendar1);
        this.conf.addProperty("calendar.list3", (Object)calendar2);
        this.conf.addPropertyDirect("calendar.list4", (Object)new Calendar[]{calendar1, calendar2});
        this.conf.addPropertyDirect("calendar.list5", (Object)new Date[]{date1, date2});
        ArrayList<Date> calendars = new ArrayList<Date>();
        calendars.add(date1);
        calendars.add(date2);
        this.conf.addProperty("calendar.list6", calendars);
        this.conf.addProperty("calendar.list.interpolated", (Object)"${calendar.string},2004-12-31");
        this.conf.addPropertyDirect("calendar.list7", (Object)new String[]{"2004-01-01", "2004-12-31"});
        this.conf.addProperty("ip.string", (Object)"127.0.0.1");
        this.conf.addProperty("ip.string.interpolated", (Object)"${ip.string}");
        this.conf.addProperty("ip.object", (Object)InetAddress.getByName("127.0.0.1"));
        this.conf.addProperty("email.string", (Object)"dev@test.org");
        this.conf.addProperty("email.string.interpolated", (Object)"${email.string}");
        this.conf.addProperty("email.object", (Object)new InternetAddress("dev@test.org"));
    }

    @Test
    public void testClearProperty() {
        String key = "test.property";
        this.conf.addProperty("test.property", (Object)"someValue");
        this.conf.clearProperty("test.property");
        Assertions.assertFalse((boolean)this.conf.containsKey("test.property"));
    }

    @Test
    public void testClearPropertyDirect() {
        String key = "test.property";
        this.conf.addProperty("test.property", (Object)"someValue");
        this.conf.clearPropertyDirect("test.property");
        Assertions.assertFalse((boolean)this.conf.containsKey("test.property"));
    }

    @Test
    public void testClearPropertyDirectNoAbstractConf() {
        Configuration wrapped = (Configuration)Mockito.mock(Configuration.class);
        String key = "test.property";
        this.conf = new DataConfiguration(wrapped);
        this.conf.clearPropertyDirect("test.property");
        ((Configuration)Mockito.verify((Object)wrapped)).clearProperty("test.property");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{wrapped});
    }

    @Test
    public void testContainsKey() {
        BaseConfiguration baseconf = new BaseConfiguration();
        DataConfiguration conf = new DataConfiguration((Configuration)baseconf);
        Assertions.assertFalse((boolean)conf.containsKey("foo"));
        baseconf.setProperty("foo", (Object)"bar");
        Assertions.assertTrue((boolean)conf.containsKey("foo"));
    }

    @Test
    public void testContainsValue() {
        Configuration config = this.conf.getConfiguration();
        Assertions.assertFalse((boolean)config.containsValue(null));
        Assertions.assertTrue((boolean)config.containsValue((Object)""));
    }

    @Test
    public void testConversionException() throws Exception {
        this.conf.addProperty("key1", new Object());
        this.conf.addProperty("key2", (Object)"xxxxxx");
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBooleanArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBooleanArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBooleanList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBooleanList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getByteArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getByteArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getByteList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getByteList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getShortArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getShortArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getShortList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getShortList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getIntArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getIntArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getIntegerList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getIntegerList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getLongArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getLongArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getLongList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getLongList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getFloatArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getFloatArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getFloatList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getFloatList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getDoubleArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getDoubleArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getDoubleList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getDoubleList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBigIntegerArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBigIntegerArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBigIntegerList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBigIntegerList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBigDecimalArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBigDecimalArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBigDecimalList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getBigDecimalList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getURLArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getURLArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getURLList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getURLList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getLocaleArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getLocaleArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getLocaleList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getLocaleList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getColorArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getColorArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getColorList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getColorList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getDateArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getDateArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getDate("key1", DATE_PATTERN));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getDate("key2", DATE_PATTERN));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getDateList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getDateList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getCalendar("key1", DATE_PATTERN));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getCalendar("key2", DATE_PATTERN));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getCalendarArray("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getCalendarArray("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getCalendarList("key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getCalendarList("key2"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.get(InetAddress.class, "key1"));
        Assertions.assertThrows(ConversionException.class, () -> this.conf.get(InternetAddress.class, "key1"));
    }

    @Test
    public void testConversionExceptionCause() {
        ConversionException cex = (ConversionException)Assertions.assertThrows(ConversionException.class, () -> this.conf.get(Integer.TYPE, "uri.string"));
        Assertions.assertInstanceOf(NumberFormatException.class, (Object)cex.getCause());
    }

    @Test
    public void testGetArrayInvalidDefaultType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.conf.getArray(Boolean.class, "unknownkey", (Object)new URL[0]));
    }

    @Test
    public void testGetBigDecimalArray() {
        Object[] defaultValue = new BigDecimal[]{new BigDecimal("2"), new BigDecimal("1")};
        Assertions.assertArrayEquals((Object[])defaultValue, (Object[])this.conf.getBigDecimalArray("bigdecimal.list", (BigDecimal[])defaultValue));
        Object[] expected = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("2")};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list1"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list2"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list3"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list4"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list6"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list.interpolated"));
        Assertions.assertArrayEquals((Object[])new BigDecimal[]{new BigDecimal("1")}, (Object[])this.conf.getBigDecimalArray("bigdecimal.string"));
        Assertions.assertArrayEquals((Object[])new BigDecimal[]{new BigDecimal("1")}, (Object[])this.conf.getBigDecimalArray("bigdecimal.object"));
        Assertions.assertArrayEquals((Object[])new BigDecimal[0], (Object[])this.conf.getBigDecimalArray("empty"));
    }

    @Test
    public void testGetBigDecimalList() {
        Assertions.assertNull((Object)this.conf.getBigDecimalList("bigdecimal.list", null));
        ArrayList<BigDecimal> expected = new ArrayList<BigDecimal>();
        expected.add(new BigDecimal("1"));
        expected.add(new BigDecimal("2"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigDecimalList("bigdecimal.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigDecimalList("bigdecimal.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigDecimalList("bigdecimal.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigDecimalList("bigdecimal.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigDecimalList("bigdecimal.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigDecimalList("bigdecimal.list.interpolated"));
        expected = new ArrayList();
        expected.add(new BigDecimal("1"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigDecimalList("bigdecimal.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigDecimalList("bigdecimal.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getBigDecimalList("empty"));
    }

    @Test
    public void testGetBigIntegerArray() {
        Object[] defaultValue = new BigInteger[]{new BigInteger("2"), new BigInteger("1")};
        Assertions.assertArrayEquals((Object[])defaultValue, (Object[])this.conf.getBigIntegerArray("biginteger.list", (BigInteger[])defaultValue));
        Object[] expected = new BigInteger[]{new BigInteger("1"), new BigInteger("2")};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list1"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list2"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list3"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list4"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list6"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list.interpolated"));
        Assertions.assertArrayEquals((Object[])new BigInteger[]{new BigInteger("1")}, (Object[])this.conf.getBigIntegerArray("biginteger.string"));
        Assertions.assertArrayEquals((Object[])new BigInteger[]{new BigInteger("1")}, (Object[])this.conf.getBigIntegerArray("biginteger.object"));
        Assertions.assertArrayEquals((Object[])new BigInteger[0], (Object[])this.conf.getBigIntegerArray("empty"));
    }

    @Test
    public void testGetBigIntegerList() {
        List bigIntegerList = this.conf.getBigIntegerList("biginteger.list", null);
        Assertions.assertNull((Object)bigIntegerList);
        ArrayList<BigInteger> expected = new ArrayList<BigInteger>();
        expected.add(new BigInteger("1"));
        expected.add(new BigInteger("2"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigIntegerList("biginteger.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigIntegerList("biginteger.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigIntegerList("biginteger.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigIntegerList("biginteger.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigIntegerList("biginteger.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigIntegerList("biginteger.list.interpolated"));
        expected = new ArrayList();
        expected.add(new BigInteger("1"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigIntegerList("biginteger.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getBigIntegerList("biginteger.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getBigIntegerList("empty"));
    }

    @Test
    public void testGetBooleanArray() {
        boolean[] defaultValue = new boolean[]{false, true};
        Assertions.assertArrayEquals((boolean[])defaultValue, (boolean[])this.conf.getBooleanArray("boolean.list", defaultValue));
        boolean[] expected = new boolean[]{true, false};
        Assertions.assertArrayEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list1"));
        Assertions.assertArrayEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list2"));
        Assertions.assertArrayEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list3"));
        Assertions.assertArrayEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list4"));
        Assertions.assertArrayEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list5"));
        Assertions.assertArrayEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list6"));
        Assertions.assertArrayEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list.interpolated"));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])this.conf.getBooleanArray("boolean.string"));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])this.conf.getBooleanArray("boolean.object"));
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])this.conf.getBooleanArray("empty"));
    }

    @Test
    public void testGetBooleanList() {
        Assertions.assertNull((Object)this.conf.getBooleanList("boolean.list", null));
        ArrayList<Boolean> expected = new ArrayList<Boolean>();
        expected.add(Boolean.TRUE);
        expected.add(Boolean.FALSE);
        Assertions.assertEquals(expected, (Object)this.conf.getBooleanList("boolean.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getBooleanList("boolean.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getBooleanList("boolean.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getBooleanList("boolean.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getBooleanList("boolean.list5"));
        Assertions.assertEquals(expected, (Object)this.conf.getBooleanList("boolean.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getBooleanList("boolean.list.interpolated"));
        expected = new ArrayList();
        expected.add(Boolean.TRUE);
        Assertions.assertEquals(expected, (Object)this.conf.getBooleanList("boolean.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getBooleanList("boolean.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getBooleanList("empty"));
    }

    @Test
    public void testGetByteArray() {
        byte[] defaultValue = new byte[]{1, 2};
        Assertions.assertArrayEquals((byte[])defaultValue, (byte[])this.conf.getByteArray("byte.list", defaultValue));
        byte[] expected = new byte[]{1, 2};
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list1"));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list2"));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list3"));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list4"));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list5"));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list6"));
        Assertions.assertArrayEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list.interpolated"));
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])this.conf.getByteArray("byte.string"));
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])this.conf.getByteArray("byte.object"));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])this.conf.getByteArray("empty"));
    }

    @Test
    public void testGetByteList() {
        Assertions.assertNull((Object)this.conf.getByteList("byte.list", null));
        ArrayList<Byte> expected = new ArrayList<Byte>();
        expected.add(Byte.valueOf("1"));
        expected.add(Byte.valueOf("2"));
        Assertions.assertEquals(expected, (Object)this.conf.getByteList("byte.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getByteList("byte.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getByteList("byte.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getByteList("byte.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getByteList("byte.list5"));
        Assertions.assertEquals(expected, (Object)this.conf.getByteList("byte.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getByteList("byte.list.interpolated"));
        expected = new ArrayList();
        expected.add(Byte.valueOf("1"));
        Assertions.assertEquals(expected, (Object)this.conf.getByteList("byte.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getByteList("byte.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getByteList("empty"));
    }

    @Test
    public void testGetCalendar() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        Calendar defaultValue = Calendar.getInstance();
        defaultValue.setTime(new Date());
        Assertions.assertEquals((Object)this.conf.getCalendar("calendar", defaultValue), (Object)defaultValue);
        Assertions.assertNull((Object)this.conf.getCalendar("unknownkey", DATE_PATTERN));
        this.conf.setThrowExceptionOnMissing(true);
        Assertions.assertThrows(NoSuchElementException.class, () -> this.conf.getCalendar("unknownkey", DATE_PATTERN));
        Calendar expected = Calendar.getInstance();
        expected.setTime(format.parse("2004-01-01"));
        Assertions.assertEquals((Object)expected, (Object)this.conf.getCalendar("calendar.string"));
        Assertions.assertEquals((Object)this.conf.getCalendar("calendar.string", DATE_PATTERN), (Object)expected);
        Assertions.assertEquals((Object)expected, (Object)this.conf.getCalendar("calendar.object"));
        Assertions.assertEquals((Object)expected, (Object)this.conf.getCalendar("date.object"));
        Assertions.assertEquals((Object)expected, (Object)this.conf.getCalendar("calendar.string.interpolated"));
    }

    @Test
    public void testGetCalendarArray() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        Date date1 = format.parse("2004-01-01");
        Date date2 = format.parse("2004-12-31");
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        Object[] defaultValue = new Calendar[]{calendar2, calendar1};
        Assertions.assertArrayEquals((Object[])defaultValue, (Object[])this.conf.getCalendarArray("calendar.list", (Calendar[])defaultValue));
        Object[] expected = new Calendar[]{calendar1, calendar2};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list1"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list2"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list3"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list4"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list5"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list6"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list.interpolated"));
        Assertions.assertArrayEquals((Object[])new Calendar[]{calendar1}, (Object[])this.conf.getCalendarArray("calendar.string"));
        Assertions.assertArrayEquals((Object[])new Calendar[]{calendar1}, (Object[])this.conf.getCalendarArray("calendar.object"));
        Assertions.assertArrayEquals((Object[])new Calendar[0], (Object[])this.conf.getCalendarArray("empty"));
    }

    @Test
    public void testGetCalendarArrayWithFormat() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        Date date1 = format.parse("01/01/2004");
        Date date2 = format.parse("12/31/2004");
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        Object[] expected = new Calendar[]{calendar1, calendar2};
        this.conf.addProperty("calendar.format", (Object)"01/01/2004");
        this.conf.addProperty("calendar.format", (Object)"12/31/2004");
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.format", "MM/dd/yyyy"));
    }

    @Test
    public void testGetCalendarList() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        Date date1 = format.parse("2004-01-01");
        Date date2 = format.parse("2004-12-31");
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        List nullList = null;
        Assertions.assertNull((Object)this.conf.getCalendarList("calendar.list", nullList));
        ArrayList<Calendar> expected = new ArrayList<Calendar>();
        expected.add(calendar1);
        expected.add(calendar2);
        Assertions.assertEquals(expected, (Object)this.conf.getCalendarList("calendar.list1"));
        Assertions.assertEquals((Object)this.conf.getList(Calendar.class, "calendar.list1"), expected);
        Assertions.assertEquals(expected, (Object)this.conf.getCalendarList("calendar.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getCalendarList("calendar.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getCalendarList("calendar.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getCalendarList("calendar.list5"));
        Assertions.assertEquals(expected, (Object)this.conf.getCalendarList("calendar.list6"));
        Assertions.assertEquals((Object)this.conf.getList(Calendar.class, "calendar.list7"), expected);
        Assertions.assertEquals(expected, (Object)this.conf.getCalendarList("calendar.list.interpolated"));
        expected = new ArrayList();
        expected.add(calendar1);
        Assertions.assertEquals(expected, (Object)this.conf.getCalendarList("date.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getCalendarList("date.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getCalendarList("empty"));
    }

    @Test
    public void testGetColor() {
        this.conf.setProperty("color", (Object)"FF0000");
        Assertions.assertEquals((Object)Color.red, (Object)this.conf.getColor("color"));
        this.conf.setProperty("color", (Object)"#00FF00");
        Assertions.assertEquals((Object)Color.green, (Object)this.conf.getColor("color"));
        this.conf.setProperty("color", (Object)"#01030507");
        Color color = this.conf.getColor("color");
        Assertions.assertNotNull((Object)color);
        Assertions.assertEquals((int)1, (int)color.getRed());
        Assertions.assertEquals((int)3, (int)color.getGreen());
        Assertions.assertEquals((int)5, (int)color.getBlue());
        Assertions.assertEquals((int)7, (int)color.getAlpha());
        Assertions.assertEquals((Object)Color.red, (Object)this.conf.getColor("color.string.interpolated"));
        Assertions.assertEquals((Object)Color.cyan, (Object)this.conf.getColor("unknownkey", Color.cyan));
    }

    @Test
    public void testGetColorArray() throws Exception {
        Object[] defaultValue = new Color[]{Color.red, Color.blue};
        Assertions.assertArrayEquals((Object[])defaultValue, (Object[])this.conf.getColorArray("color.list", (Color[])defaultValue));
        Object[] expected = new Color[]{Color.red, Color.blue};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list1"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list2"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list3"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list4"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list6"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list.interpolated"));
        Assertions.assertArrayEquals((Object[])new Color[]{Color.red}, (Object[])this.conf.getColorArray("color.string"));
        Assertions.assertArrayEquals((Object[])new Color[]{Color.red}, (Object[])this.conf.getColorArray("color.object"));
        Assertions.assertArrayEquals((Object[])new Color[0], (Object[])this.conf.getColorArray("empty"));
    }

    @Test
    public void testGetColorList() throws Exception {
        Assertions.assertNull((Object)this.conf.getColorList("color.list", null));
        ArrayList<Color> expected = new ArrayList<Color>();
        expected.add(Color.red);
        expected.add(Color.blue);
        Assertions.assertEquals(expected, (Object)this.conf.getColorList("color.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getColorList("color.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getColorList("color.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getColorList("color.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getColorList("color.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getColorList("color.list.interpolated"));
        expected = new ArrayList();
        expected.add(Color.red);
        Assertions.assertEquals(expected, (Object)this.conf.getColorList("color.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getColorList("color.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getColorList("empty"));
    }

    @Test
    public void testGetConfiguration() {
        BaseConfiguration baseconf = new BaseConfiguration();
        DataConfiguration conf = new DataConfiguration((Configuration)baseconf);
        Assertions.assertEquals((Object)baseconf, (Object)conf.getConfiguration());
    }

    @Test
    public void testGetDate() throws Exception {
        Date expected = TestDataConfiguration.expectedDate();
        Date defaultValue = new Date();
        Assertions.assertEquals((Object)this.conf.getDate("date", defaultValue), (Object)defaultValue);
        Assertions.assertNull((Object)this.conf.getDate("unknownkey", DATE_PATTERN));
        this.conf.setThrowExceptionOnMissing(true);
        Assertions.assertThrows(NoSuchElementException.class, () -> this.conf.getDate("unknownkey", DATE_PATTERN));
        Assertions.assertEquals((Object)expected, (Object)this.conf.getDate("date.string"));
        Assertions.assertEquals((Object)this.conf.getDate("date.string", DATE_PATTERN), (Object)expected);
        Assertions.assertEquals((Object)expected, (Object)this.conf.getDate("date.object"));
        Assertions.assertEquals((Object)expected, (Object)this.conf.getDate("calendar.object"));
        Assertions.assertEquals((Object)expected, (Object)this.conf.getDate("date.string.interpolated"));
    }

    @Test
    public void testGetDateArray() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        Date date1 = format.parse("2004-01-01");
        Date date2 = format.parse("2004-12-31");
        Object[] defaultValue = new Date[]{date2, date1};
        Assertions.assertArrayEquals((Object[])defaultValue, (Object[])this.conf.getDateArray("date.list", (Date[])defaultValue));
        Object[] expected = new Date[]{date1, date2};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list1"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list2"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list3"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list4"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list5"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list6"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list.interpolated"));
        Assertions.assertArrayEquals((Object[])new Date[]{date1}, (Object[])this.conf.getDateArray("date.string"));
        Assertions.assertArrayEquals((Object[])new Date[]{date1}, (Object[])this.conf.getDateArray("date.object"));
        Assertions.assertArrayEquals((Object[])new Date[0], (Object[])this.conf.getDateArray("empty"));
    }

    @Test
    public void testGetDateArrayWithFormat() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        Date date1 = format.parse("01/01/2004");
        Date date2 = format.parse("12/31/2004");
        Object[] expected = new Date[]{date1, date2};
        this.conf.addProperty("date.format", (Object)"01/01/2004");
        this.conf.addProperty("date.format", (Object)"12/31/2004");
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getDateArray("date.format", "MM/dd/yyyy"));
    }

    @Test
    public void testGetDateList() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        Date date1 = format.parse("2004-01-01");
        Date date2 = format.parse("2004-12-31");
        List nullList = null;
        Assertions.assertNull((Object)this.conf.getDateList("date.list", nullList));
        ArrayList<Date> expected = new ArrayList<Date>();
        expected.add(date1);
        expected.add(date2);
        Assertions.assertEquals(expected, (Object)this.conf.getDateList("date.list1"));
        Assertions.assertEquals((Object)this.conf.getList(Date.class, "date.list1"), expected);
        Assertions.assertEquals(expected, (Object)this.conf.getDateList("date.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getDateList("date.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getDateList("date.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getDateList("date.list5"));
        Assertions.assertEquals(expected, (Object)this.conf.getDateList("date.list6"));
        Assertions.assertEquals((Object)this.conf.getList(Date.class, "date.list7"), expected);
        Assertions.assertEquals(expected, (Object)this.conf.getDateList("date.list.interpolated"));
        expected = new ArrayList();
        expected.add(date1);
        Assertions.assertEquals(expected, (Object)this.conf.getDateList("date.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getDateList("date.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getDateList("empty"));
    }

    @Test
    public void testGetDateNoFormatPropertyConversionHandler() throws Exception {
        this.conf.clearProperty("org.apache.commons.configuration.format.date");
        DefaultConversionHandler handler = new DefaultConversionHandler();
        handler.setDateFormat(DATE_PATTERN);
        this.conf.setConversionHandler((ConversionHandler)handler);
        Assertions.assertEquals((Object)TestDataConfiguration.expectedDate(), (Object)this.conf.getDate("date.string"));
    }

    @Test
    public void testGetDateNoFormatPropertyDirectlySpecified() throws Exception {
        this.conf.clearProperty("org.apache.commons.configuration.format.date");
        Assertions.assertEquals((Object)TestDataConfiguration.expectedDate(), (Object)this.conf.getDate("date.string", DATE_PATTERN));
    }

    @Test
    public void testGetDoubleArray() {
        double[] defaultValue = new double[]{2.0, 1.0};
        Assertions.assertArrayEquals((double[])defaultValue, (double[])this.conf.getDoubleArray("double.list", defaultValue), (double)0.0);
        double[] expected = new double[]{1.0, 2.0};
        Assertions.assertArrayEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list1"), (double)0.0);
        Assertions.assertArrayEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list2"), (double)0.0);
        Assertions.assertArrayEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list3"), (double)0.0);
        Assertions.assertArrayEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list4"), (double)0.0);
        Assertions.assertArrayEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list5"), (double)0.0);
        Assertions.assertArrayEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list6"), (double)0.0);
        Assertions.assertArrayEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list.interpolated"), (double)0.0);
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])this.conf.getDoubleArray("double.string"), (double)0.0);
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])this.conf.getDoubleArray("double.object"), (double)0.0);
        Assertions.assertArrayEquals((double[])new double[0], (double[])this.conf.getDoubleArray("empty"), (double)0.0);
    }

    @Test
    public void testGetDoubleList() {
        Assertions.assertNull((Object)this.conf.getDoubleList("double.list", null));
        ArrayList<Double> expected = new ArrayList<Double>();
        expected.add(Double.valueOf("1"));
        expected.add(Double.valueOf("2"));
        Assertions.assertEquals(expected, (Object)this.conf.getDoubleList("double.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getDoubleList("double.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getDoubleList("double.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getDoubleList("double.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getDoubleList("double.list5"));
        Assertions.assertEquals(expected, (Object)this.conf.getDoubleList("double.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getDoubleList("double.list.interpolated"));
        expected = new ArrayList();
        expected.add(Double.valueOf("1"));
        Assertions.assertEquals(expected, (Object)this.conf.getDoubleList("double.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getDoubleList("double.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getDoubleList("empty"));
    }

    @Test
    public void testGetFloatArray() {
        float[] defaultValue = new float[]{2.0f, 1.0f};
        Assertions.assertArrayEquals((float[])defaultValue, (float[])this.conf.getFloatArray("float.list", defaultValue), (float)0.0f);
        float[] expected = new float[]{1.0f, 2.0f};
        Assertions.assertArrayEquals((float[])expected, (float[])this.conf.getFloatArray("float.list1"), (float)0.0f);
        Assertions.assertArrayEquals((float[])expected, (float[])this.conf.getFloatArray("float.list2"), (float)0.0f);
        Assertions.assertArrayEquals((float[])expected, (float[])this.conf.getFloatArray("float.list3"), (float)0.0f);
        Assertions.assertArrayEquals((float[])expected, (float[])this.conf.getFloatArray("float.list4"), (float)0.0f);
        Assertions.assertArrayEquals((float[])expected, (float[])this.conf.getFloatArray("float.list5"), (float)0.0f);
        Assertions.assertArrayEquals((float[])expected, (float[])this.conf.getFloatArray("float.list6"), (float)0.0f);
        Assertions.assertArrayEquals((float[])expected, (float[])this.conf.getFloatArray("float.list.interpolated"), (float)0.0f);
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])this.conf.getFloatArray("float.string"), (float)0.0f);
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])this.conf.getFloatArray("float.object"), (float)0.0f);
        Assertions.assertArrayEquals((float[])new float[0], (float[])this.conf.getFloatArray("empty"), (float)0.0f);
    }

    @Test
    public void testGetFloatList() {
        Assertions.assertNull((Object)this.conf.getFloatList("float.list", null));
        ArrayList<Float> expected = new ArrayList<Float>();
        expected.add(Float.valueOf("1"));
        expected.add(Float.valueOf("2"));
        Assertions.assertEquals(expected, (Object)this.conf.getFloatList("float.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getFloatList("float.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getFloatList("float.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getFloatList("float.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getFloatList("float.list5"));
        Assertions.assertEquals(expected, (Object)this.conf.getFloatList("float.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getFloatList("float.list.interpolated"));
        expected = new ArrayList();
        expected.add(Float.valueOf("1"));
        Assertions.assertEquals(expected, (Object)this.conf.getFloatList("float.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getFloatList("float.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getFloatList("empty"));
    }

    @Test
    public void testGetInetAddress() throws Exception {
        InetAddress expected = InetAddress.getByName("127.0.0.1");
        Assertions.assertEquals((Object)this.conf.get(InetAddress.class, "ip.string"), (Object)expected);
        Assertions.assertEquals((Object)this.conf.get(InetAddress.class, "ip.object"), (Object)expected);
        Assertions.assertEquals((Object)this.conf.get(InetAddress.class, "ip.string.interpolated"), (Object)expected);
    }

    @Test
    public void testGetInetAddressInvalidType() {
        this.conf.setProperty("ip.unknownhost", (Object)"foo");
        Assertions.assertThrows(ConversionException.class, () -> this.conf.get(InetAddress.class, "ip.unknownhost"));
    }

    @Test
    public void testGetIntegerArray() {
        int[] defaultValue = new int[]{2, 1};
        Assertions.assertArrayEquals((int[])this.conf.getIntArray("integer.list", defaultValue), (int[])defaultValue);
        int[] expected = new int[]{1, 2};
        Assertions.assertArrayEquals((int[])expected, (int[])this.conf.getIntArray("integer.list1"));
        Assertions.assertArrayEquals((int[])expected, (int[])this.conf.getIntArray("integer.list2"));
        Assertions.assertArrayEquals((int[])expected, (int[])this.conf.getIntArray("integer.list3"));
        Assertions.assertArrayEquals((int[])expected, (int[])this.conf.getIntArray("integer.list4"));
        Assertions.assertArrayEquals((int[])expected, (int[])this.conf.getIntArray("integer.list5"));
        Assertions.assertArrayEquals((int[])expected, (int[])this.conf.getIntArray("integer.list6"));
        Assertions.assertArrayEquals((int[])expected, (int[])this.conf.getIntArray("integer.list.interpolated"));
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])this.conf.getIntArray("integer.string"));
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])this.conf.getIntArray("integer.object"));
        Assertions.assertArrayEquals((int[])new int[0], (int[])this.conf.getIntArray("empty"));
    }

    @Test
    public void testGetIntegerList() {
        Assertions.assertNull((Object)this.conf.getIntegerList("integer.list", null));
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(Integer.valueOf("1"));
        expected.add(Integer.valueOf("2"));
        Assertions.assertEquals(expected, (Object)this.conf.getIntegerList("integer.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getIntegerList("integer.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getIntegerList("integer.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getIntegerList("integer.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getIntegerList("integer.list5"));
        Assertions.assertEquals(expected, (Object)this.conf.getIntegerList("integer.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getIntegerList("integer.list.interpolated"));
        expected = new ArrayList();
        expected.add(Integer.valueOf("1"));
        Assertions.assertEquals(expected, (Object)this.conf.getIntegerList("integer.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getIntegerList("integer.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getIntegerList("empty"));
    }

    @Test
    public void testGetInternetAddress() throws Exception {
        InternetAddress expected = new InternetAddress("dev@test.org");
        Assertions.assertEquals((Object)this.conf.get(expected.getClass(), "email.string"), (Object)expected);
        Assertions.assertEquals((Object)this.conf.get(expected.getClass(), "email.object"), (Object)expected);
        Assertions.assertEquals((Object)this.conf.get(expected.getClass(), "email.string.interpolated"), (Object)expected);
        this.conf.setProperty("email.invalid", (Object)"dev@test@org");
        Assertions.assertThrows(ConversionException.class, () -> this.conf.get(expected.getClass(), "email.invalid"));
    }

    @Test
    public void testGetInternetAddressInvalidType() throws Exception {
        InternetAddress expected = new InternetAddress("dev@test.org");
        this.conf.setProperty("email.invalid", (Object)"dev@test@org");
        Assertions.assertThrows(ConversionException.class, () -> this.conf.get(expected.getClass(), "email.invalid"));
    }

    @Test
    public void testGetInvalidType() {
        Assertions.assertThrows(ConversionException.class, () -> this.conf.get(Boolean.class, "url.object", null));
    }

    @Test
    public void testGetKeys() {
        BaseConfiguration baseconf = new BaseConfiguration();
        DataConfiguration conf = new DataConfiguration((Configuration)baseconf);
        baseconf.setProperty("foo", (Object)"bar");
        Iterator it = conf.getKeys();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"foo", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testGetLocale() {
        this.conf.setProperty("locale", (Object)"fr");
        Assertions.assertEquals((Object)new Locale("fr", ""), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"fr__POSIX");
        Assertions.assertEquals((Object)new Locale("fr", "", "POSIX"), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"_FR");
        Assertions.assertEquals((Object)new Locale("", "FR"), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"_FR_WIN");
        Assertions.assertEquals((Object)new Locale("", "FR", "WIN"), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"fr_FR");
        Assertions.assertEquals((Object)new Locale("fr", "FR"), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"fr_FR_MAC");
        Assertions.assertEquals((Object)new Locale("fr", "FR", "MAC"), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"fr");
        Assertions.assertEquals((Object)Locale.FRENCH, (Object)this.conf.getLocale("locale", Locale.GERMAN));
        Assertions.assertEquals((Object)Locale.GERMAN, (Object)this.conf.getLocale("localeNotInConfig", Locale.GERMAN));
        Assertions.assertEquals((Object)Locale.FRENCH, (Object)this.conf.getLocale("locale.string.interpolated"));
    }

    @Test
    public void testGetLocaleArray() throws Exception {
        Object[] defaultValue = new Locale[]{Locale.GERMAN, Locale.FRENCH};
        Assertions.assertArrayEquals((Object[])this.conf.getLocaleArray("locale.list", (Locale[])defaultValue), (Object[])defaultValue);
        Object[] expected = new Locale[]{Locale.FRENCH, Locale.GERMAN};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list1"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list2"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list3"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list4"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list6"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list.interpolated"));
        Assertions.assertArrayEquals((Object[])new Locale[]{Locale.FRENCH}, (Object[])this.conf.getLocaleArray("locale.string"));
        Assertions.assertArrayEquals((Object[])new Locale[]{Locale.FRENCH}, (Object[])this.conf.getLocaleArray("locale.object"));
        Assertions.assertArrayEquals((Object[])new Locale[0], (Object[])this.conf.getLocaleArray("empty"));
    }

    @Test
    public void testGetLocaleList() throws Exception {
        Assertions.assertNull((Object)this.conf.getLocaleList("locale.list", null));
        ArrayList<Locale> expected = new ArrayList<Locale>();
        expected.add(Locale.FRENCH);
        expected.add(Locale.GERMAN);
        Assertions.assertEquals(expected, (Object)this.conf.getLocaleList("locale.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getLocaleList("locale.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getLocaleList("locale.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getLocaleList("locale.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getLocaleList("locale.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getLocaleList("locale.list.interpolated"));
        expected = new ArrayList();
        expected.add(Locale.FRENCH);
        Assertions.assertEquals(expected, (Object)this.conf.getLocaleList("locale.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getLocaleList("locale.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getLocaleList("empty"));
    }

    @Test
    public void testGetLongArray() {
        long[] defaultValue = new long[]{2L, 1L};
        Assertions.assertArrayEquals((long[])this.conf.getLongArray("long.list", defaultValue), (long[])defaultValue);
        long[] expected = new long[]{1L, 2L};
        Assertions.assertArrayEquals((long[])expected, (long[])this.conf.getLongArray("long.list1"));
        Assertions.assertArrayEquals((long[])expected, (long[])this.conf.getLongArray("long.list2"));
        Assertions.assertArrayEquals((long[])expected, (long[])this.conf.getLongArray("long.list3"));
        Assertions.assertArrayEquals((long[])expected, (long[])this.conf.getLongArray("long.list4"));
        Assertions.assertArrayEquals((long[])expected, (long[])this.conf.getLongArray("long.list5"));
        Assertions.assertArrayEquals((long[])expected, (long[])this.conf.getLongArray("long.list6"));
        Assertions.assertArrayEquals((long[])expected, (long[])this.conf.getLongArray("long.list.interpolated"));
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])this.conf.getLongArray("long.string"));
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])this.conf.getLongArray("long.object"));
        Assertions.assertArrayEquals((long[])new long[0], (long[])this.conf.getLongArray("empty"));
    }

    @Test
    public void testGetLongList() {
        Assertions.assertNull((Object)this.conf.getLongList("long.list", null));
        ArrayList<Long> expected = new ArrayList<Long>();
        expected.add(Long.valueOf("1"));
        expected.add(Long.valueOf("2"));
        Assertions.assertEquals(expected, (Object)this.conf.getLongList("long.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getLongList("long.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getLongList("long.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getLongList("long.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getLongList("long.list5"));
        Assertions.assertEquals(expected, (Object)this.conf.getLongList("long.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getLongList("long.list.interpolated"));
        expected = new ArrayList();
        expected.add(Long.valueOf("1"));
        Assertions.assertEquals(expected, (Object)this.conf.getLongList("long.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getLongList("long.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getLongList("empty"));
    }

    @Test
    public void testGetPrimitiveArrayInvalidType() {
        Assertions.assertThrows(ConversionException.class, () -> this.conf.getArray(Boolean.TYPE, "calendar.list4"));
    }

    @Test
    public void testGetPropertyWithoutConversion() {
        String key = "test.str";
        String value = "someTestValue";
        this.conf.addProperty("test.str", (Object)"someTestValue");
        Assertions.assertEquals((Object)"someTestValue", (Object)this.conf.get(String.class, "test.str"));
    }

    @Test
    public void testGetShortArray() {
        short[] defaultValue = new short[]{2, 1};
        Assertions.assertArrayEquals((short[])this.conf.getShortArray("short.list", defaultValue), (short[])defaultValue);
        short[] expected = new short[]{1, 2};
        Assertions.assertArrayEquals((short[])expected, (short[])this.conf.getShortArray("short.list1"));
        Assertions.assertArrayEquals((short[])expected, (short[])this.conf.getShortArray("short.list2"));
        Assertions.assertArrayEquals((short[])expected, (short[])this.conf.getShortArray("short.list3"));
        Assertions.assertArrayEquals((short[])expected, (short[])this.conf.getShortArray("short.list4"));
        Assertions.assertArrayEquals((short[])expected, (short[])this.conf.getShortArray("short.list5"));
        Assertions.assertArrayEquals((short[])expected, (short[])this.conf.getShortArray("short.list6"));
        Assertions.assertArrayEquals((short[])expected, (short[])this.conf.getShortArray("short.list.interpolated"));
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])this.conf.getShortArray("short.string"));
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])this.conf.getShortArray("short.object"));
        Assertions.assertArrayEquals((short[])new short[0], (short[])this.conf.getShortArray("empty"));
    }

    @Test
    public void testGetShortList() {
        Assertions.assertNull((Object)this.conf.getShortList("short.list", null));
        ArrayList<Short> expected = new ArrayList<Short>();
        expected.add(Short.valueOf("1"));
        expected.add(Short.valueOf("2"));
        Assertions.assertEquals(expected, (Object)this.conf.getShortList("short.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getShortList("short.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getShortList("short.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getShortList("short.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getShortList("short.list5"));
        Assertions.assertEquals(expected, (Object)this.conf.getShortList("short.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getShortList("short.list.interpolated"));
        expected = new ArrayList();
        expected.add(Short.valueOf("1"));
        Assertions.assertEquals(expected, (Object)this.conf.getShortList("short.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getShortList("short.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getShortList("empty"));
    }

    @Test
    public void testGetUnknown() {
        Assertions.assertNull((Object)this.conf.get(Object.class, "unknownkey"));
    }

    @Test
    public void testGetUnknownException() {
        this.conf.setThrowExceptionOnMissing(true);
        Assertions.assertThrows(NoSuchElementException.class, () -> this.conf.get(Object.class, "unknownkey"));
    }

    @Test
    public void testGetURI() throws Exception {
        URI defaultValue = new URI("http://www.google.com");
        Assertions.assertEquals((Object)this.conf.getURI("url", defaultValue), (Object)defaultValue);
        URI expected = new URI("http://jakarta.apache.org");
        Assertions.assertEquals((Object)expected, (Object)this.conf.getURI("uri.string"));
        Assertions.assertEquals((Object)expected, (Object)this.conf.getURI("uri.object"));
        Assertions.assertEquals((Object)expected, (Object)this.conf.getURI("uri.string.interpolated"));
    }

    @Test
    public void testGetURIArray() throws Exception {
        Object[] defaultValue = new URI[]{new URI("http://www.apache.org"), new URI("http://jakarta.apache.org")};
        Assertions.assertArrayEquals((Object[])this.conf.getURIArray("url.list", (URI[])defaultValue), (Object[])defaultValue);
        Object[] expected = new URI[]{new URI("http://jakarta.apache.org"), new URI("http://www.apache.org")};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list1"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list2"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list3"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list4"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list6"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list.interpolated"));
        Assertions.assertArrayEquals((Object[])new URI[]{new URI("http://jakarta.apache.org")}, (Object[])this.conf.getURIArray("uri.string"));
        Assertions.assertArrayEquals((Object[])new URI[]{new URI("http://jakarta.apache.org")}, (Object[])this.conf.getURIArray("uri.object"));
        Assertions.assertArrayEquals((Object[])new URI[0], (Object[])this.conf.getURIArray("empty"));
    }

    @Test
    public void testGetURIList() throws Exception {
        Assertions.assertNull((Object)this.conf.getURIList("uri.list", null));
        ArrayList<URI> expected = new ArrayList<URI>();
        expected.add(new URI("http://jakarta.apache.org"));
        expected.add(new URI("http://www.apache.org"));
        Assertions.assertEquals(expected, (Object)this.conf.getURIList("uri.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getURIList("uri.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getURIList("uri.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getURIList("uri.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getURIList("uri.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getURIList("uri.list.interpolated"));
        expected = new ArrayList();
        expected.add(new URI("http://jakarta.apache.org"));
        Assertions.assertEquals(expected, (Object)this.conf.getURIList("uri.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getURIList("uri.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getURIList("empty"));
    }

    @Test
    public void testGetURL() throws Exception {
        URL defaultValue = new URL("http://www.google.com");
        Assertions.assertEquals((Object)this.conf.getURL("url", defaultValue), (Object)defaultValue);
        URL expected = new URL("http://jakarta.apache.org");
        Assertions.assertEquals((Object)expected, (Object)this.conf.getURL("url.string"));
        Assertions.assertEquals((Object)expected, (Object)this.conf.getURL("url.object"));
        Assertions.assertEquals((Object)expected, (Object)this.conf.getURL("url.string.interpolated"));
    }

    @Test
    public void testGetURLArray() throws Exception {
        Object[] defaultValue = new URL[]{new URL("http://www.apache.org"), new URL("http://jakarta.apache.org")};
        Assertions.assertArrayEquals((Object[])this.conf.getURLArray("url.list", (URL[])defaultValue), (Object[])defaultValue);
        Object[] expected = new URL[]{new URL("http://jakarta.apache.org"), new URL("http://www.apache.org")};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list1"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list2"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list3"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list4"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list6"));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list.interpolated"));
        Assertions.assertArrayEquals((Object[])new URL[]{new URL("http://jakarta.apache.org")}, (Object[])this.conf.getURLArray("url.string"));
        Assertions.assertArrayEquals((Object[])new URL[]{new URL("http://jakarta.apache.org")}, (Object[])this.conf.getURLArray("url.object"));
        Assertions.assertArrayEquals((Object[])new URL[0], (Object[])this.conf.getURLArray("empty"));
    }

    @Test
    public void testGetURLList() throws Exception {
        Assertions.assertNull((Object)this.conf.getURLList("url.list", null));
        ArrayList<URL> expected = new ArrayList<URL>();
        expected.add(new URL("http://jakarta.apache.org"));
        expected.add(new URL("http://www.apache.org"));
        Assertions.assertEquals(expected, (Object)this.conf.getURLList("url.list1"));
        Assertions.assertEquals(expected, (Object)this.conf.getURLList("url.list2"));
        Assertions.assertEquals(expected, (Object)this.conf.getURLList("url.list3"));
        Assertions.assertEquals(expected, (Object)this.conf.getURLList("url.list4"));
        Assertions.assertEquals(expected, (Object)this.conf.getURLList("url.list6"));
        Assertions.assertEquals(expected, (Object)this.conf.getURLList("url.list.interpolated"));
        expected = new ArrayList();
        expected.add(new URL("http://jakarta.apache.org"));
        Assertions.assertEquals(expected, (Object)this.conf.getURLList("url.string"));
        Assertions.assertEquals(expected, (Object)this.conf.getURLList("url.object"));
        Assertions.assertEquals(new ArrayList(), (Object)this.conf.getURLList("empty"));
    }

    @Test
    public void testIsEmpty() {
        BaseConfiguration baseconf = new BaseConfiguration();
        DataConfiguration conf = new DataConfiguration((Configuration)baseconf);
        Assertions.assertTrue((boolean)conf.isEmpty());
        baseconf.setProperty("foo", (Object)"bar");
        Assertions.assertFalse((boolean)conf.isEmpty());
    }

    @Test
    public void testNullConfiguration() {
        Assertions.assertThrows(NullPointerException.class, () -> new DataConfiguration(null));
    }
}

