/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale.converters;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils2.locale.BaseLocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DecimalLocaleConverter<T extends Number>
extends BaseLocaleConverter<T> {
    private static final Log LOG = LogFactory.getLog(DecimalLocaleConverter.class);

    public static <B extends Builder<B, T>, T extends Number> B builder() {
        return (B)new Builder();
    }

    protected DecimalLocaleConverter(T defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        super(defaultValue, locale, pattern, useDefault, locPattern);
    }

    @Override
    protected T parse(Object value, String pattern) throws ParseException {
        if (value instanceof Number) {
            return (T)((Number)value);
        }
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(this.locale);
        if (pattern != null) {
            if (this.localizedPattern) {
                formatter.applyLocalizedPattern(pattern);
            } else {
                formatter.applyPattern(pattern);
            }
        } else {
            LOG.debug((Object)"No pattern provided, using default.");
        }
        return (T)formatter.parse((String)value);
    }

    public static class Builder<B extends Builder<B, T>, T extends Number>
    extends BaseLocaleConverter.Builder<B, T> {
        @Override
        public DecimalLocaleConverter<?> get() {
            return new DecimalLocaleConverter<Number>((Number)this.defaultValue, this.locale, this.pattern, this.useDefault || this.defaultValue != null, this.localizedPattern);
        }
    }
}

