/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesMethodReaderBuilder;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BytesIn<U>
extends RandomDataInput,
StreamingDataInput<Bytes<U>>,
ByteStringParser<Bytes<U>> {
    @NotNull
    default public MethodReader bytesMethodReader(Object ... objects) {
        return new BytesMethodReaderBuilder(this).build(objects);
    }

    @NotNull
    default public BytesMethodReaderBuilder bytesMethodReaderBuilder() {
        return new BytesMethodReaderBuilder(this);
    }

    public <T extends ReadBytesMarshallable> T readMarshallableLength16(@NotNull Class<T> var1, @Nullable T var2) throws BufferUnderflowException, IllegalStateException;

    default public <T> T readObject(@NotNull Class<T> componentType0) throws BufferUnderflowException, IllegalArgumentException, IllegalStateException, ArithmeticException, BufferOverflowException {
        Class componentType = ObjectUtils.implementationToUse(componentType0);
        if (BytesMarshallable.class.isAssignableFrom(componentType)) {
            BytesMarshallable bm = (BytesMarshallable)ObjectUtils.newInstance((Class)componentType);
            bm.readMarshallable(this);
            return (T)bm;
        }
        if (Enum.class.isAssignableFrom(componentType)) {
            return (T)this.readEnum(componentType);
        }
        switch (componentType.getName()) {
            case "java.lang.String": {
                return (T)this.readUtf8();
            }
            case "java.lang.Double": {
                return (T)Double.valueOf(this.readDouble());
            }
            case "java.lang.Long": {
                return (T)Long.valueOf(this.readLong());
            }
            case "java.lang.Integer": {
                return (T)Integer.valueOf(this.readInt());
            }
        }
        throw new UnsupportedOperationException("Unsupported " + componentType);
    }
}

