/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.MmappedRegions;

@NotThreadSafe
public class MmappedRegionsCache
implements AutoCloseable {
    private final Map<File, MmappedRegions> cache = new HashMap<File, MmappedRegions>();
    private boolean closed = false;

    public MmappedRegions getOrCreate(ChannelProxy channel, long length) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        MmappedRegions regions = this.cache.computeIfAbsent(channel.file(), ignored -> MmappedRegions.map(channel, length));
        Preconditions.checkArgument((boolean)regions.isValid(channel));
        regions.extend(length);
        return regions.sharedCopy();
    }

    public MmappedRegions getOrCreate(ChannelProxy channel, CompressionMetadata metadata) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        MmappedRegions regions = this.cache.computeIfAbsent(channel.file(), ignored -> MmappedRegions.map(channel, metadata));
        Preconditions.checkArgument((boolean)regions.isValid(channel));
        regions.extend(metadata);
        return regions.sharedCopy();
    }

    @Override
    public void close() {
        this.closed = true;
        Iterator<MmappedRegions> it = this.cache.values().iterator();
        while (it.hasNext()) {
            MmappedRegions region = it.next();
            region.closeQuietly();
            it.remove();
        }
    }
}

