/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.vector;

import java.util.function.Function;

public class DiskBinarySearch {
    public static long searchInt(long low, long high, int target, Function<Long, Integer> f) {
        assert (high < 0x1FFFFFFFFFFFFFFFL) : "high is too large to avoid potential overflow: " + high;
        assert (low < high) : "low must be less than high: " + low + " >= " + high;
        while (low < high) {
            long i = low + (high - low) / 2L;
            int value = f.apply(i);
            if (target == value) {
                return i;
            }
            if (target > value) {
                low = i + 1L;
                continue;
            }
            high = i;
        }
        return -1L;
    }
}

