/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.QueryCancelledException;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeUnionIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSearchResultIterator
extends KeyRangeIterator {
    private static final Logger logger = LoggerFactory.getLogger(IndexSearchResultIterator.class);
    private final KeyRangeIterator union;

    private IndexSearchResultIterator(KeyRangeIterator union, Runnable onClose) {
        super(union.getMinimum(), union.getMaximum(), union.getMaxKeys(), onClose);
        this.union = union;
    }

    public static IndexSearchResultIterator build(Expression expression, Collection<SSTableIndex> sstableIndexes, AbstractBounds<PartitionPosition> keyRange, QueryContext queryContext, boolean includeMemtables, Runnable onClose) {
        Object memtableIterator;
        ArrayList<KeyRangeIterator> subIterators = new ArrayList<KeyRangeIterator>(sstableIndexes.size() + (includeMemtables ? 1 : 0));
        if (includeMemtables && (memtableIterator = expression.getIndex().memtableIndexManager().searchMemtableIndexes(queryContext, expression, keyRange)) != null) {
            subIterators.add((KeyRangeIterator)memtableIterator);
        }
        for (SSTableIndex sstableIndex : sstableIndexes) {
            try {
                queryContext.checkpoint();
                ++queryContext.sstablesHit;
                if (sstableIndex.isReleased()) {
                    throw new IllegalStateException(sstableIndex.getIndexIdentifier().logMessage("Index was released from the view during the query"));
                }
                List<KeyRangeIterator> indexIterators = sstableIndex.search(expression, keyRange, queryContext);
                if (indexIterators.isEmpty()) continue;
                subIterators.addAll(indexIterators);
            }
            catch (Throwable e) {
                if (!(e instanceof QueryCancelledException)) {
                    logger.debug(sstableIndex.getIndexIdentifier().logMessage(String.format("Failed search an index %s, aborting query.", sstableIndex.getSSTable())), e);
                }
                throw Throwables.cleaned(e);
            }
        }
        KeyRangeIterator union = KeyRangeUnionIterator.build(subIterators, () -> {});
        return new IndexSearchResultIterator(union, onClose);
    }

    public static IndexSearchResultIterator build(List<KeyRangeIterator> sstableIntersections, KeyRangeIterator memtableResults, Set<SSTableIndex> referencedIndexes, QueryContext queryContext, Runnable onClose) {
        queryContext.sstablesHit += (long)referencedIndexes.stream().map(SSTableIndex::getSSTable).collect(Collectors.toSet()).size();
        queryContext.checkpoint();
        KeyRangeIterator union = KeyRangeUnionIterator.builder(sstableIntersections.size() + 1, () -> {}).add(sstableIntersections).add(memtableResults).build();
        return new IndexSearchResultIterator(union, onClose);
    }

    @Override
    protected PrimaryKey computeNext() {
        return this.union.hasNext() ? (PrimaryKey)this.union.next() : (PrimaryKey)this.endOfData();
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        this.union.skipTo(nextKey);
    }

    @Override
    public void close() {
        super.close();
        FileUtils.closeQuietly(this.union);
    }
}

