/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.partitions.PartitionStatisticsCollector;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.CounterCells;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.schema.ColumnMetadata;

public abstract class Cells {
    private Cells() {
    }

    public static void collectStats(Cell<?> cell, PartitionStatisticsCollector collector) {
        collector.update(cell);
        if (cell.isCounterCell()) {
            collector.updateHasLegacyCounterShards(CounterCells.hasLegacyShards(cell));
        }
    }

    public static Cell<?> reconcile(Cell<?> c1, Cell<?> c2) {
        if (c1 == null || c2 == null) {
            return c2 == null ? c1 : c2;
        }
        if (c1.isCounterCell() || c2.isCounterCell()) {
            return Cells.resolveCounter(c1, c2);
        }
        return Cells.resolveRegular(c1, c2);
    }

    private static Cell<?> resolveRegular(Cell<?> left, Cell<?> right) {
        boolean rightIsExpiringOrTombstone;
        long rightTimestamp;
        long leftTimestamp = left.timestamp();
        if (leftTimestamp != (rightTimestamp = right.timestamp())) {
            return leftTimestamp > rightTimestamp ? left : right;
        }
        long leftLocalDeletionTime = left.localDeletionTime();
        long rightLocalDeletionTime = right.localDeletionTime();
        boolean leftIsExpiringOrTombstone = leftLocalDeletionTime != Long.MAX_VALUE;
        boolean bl = rightIsExpiringOrTombstone = rightLocalDeletionTime != Long.MAX_VALUE;
        if (leftIsExpiringOrTombstone | rightIsExpiringOrTombstone) {
            boolean rightIsTombstone;
            if (leftIsExpiringOrTombstone != rightIsExpiringOrTombstone) {
                return leftIsExpiringOrTombstone ? left : right;
            }
            boolean leftIsTombstone = !left.isExpiring();
            boolean bl2 = rightIsTombstone = !right.isExpiring();
            if (leftIsTombstone != rightIsTombstone) {
                return leftIsTombstone ? left : right;
            }
            if (leftLocalDeletionTime != rightLocalDeletionTime) {
                return leftLocalDeletionTime > rightLocalDeletionTime ? left : right;
            }
        }
        return Cells.compareValues(left, right) >= 0 ? left : right;
    }

    private static Cell<?> resolveCounter(Cell<?> left, Cell<?> right) {
        boolean rightIsEmpty;
        boolean rightIsTombstone;
        long leftTimestamp = left.timestamp();
        long rightTimestamp = right.timestamp();
        boolean leftIsTombstone = left.isTombstone();
        if (leftIsTombstone | (rightIsTombstone = right.isTombstone())) {
            assert (leftIsTombstone != rightIsTombstone);
            return leftIsTombstone ? left : right;
        }
        ByteBuffer leftValue = left.buffer();
        ByteBuffer rightValue = right.buffer();
        boolean leftIsEmpty = !leftValue.hasRemaining();
        boolean bl = rightIsEmpty = !rightValue.hasRemaining();
        if (leftIsEmpty || rightIsEmpty) {
            if (leftIsEmpty != rightIsEmpty) {
                return leftIsEmpty ? left : right;
            }
            return leftTimestamp > rightTimestamp ? left : right;
        }
        ByteBuffer merged = CounterContext.instance().merge(leftValue, rightValue);
        long timestamp = Math.max(leftTimestamp, rightTimestamp);
        if (merged == leftValue && timestamp == leftTimestamp) {
            return left;
        }
        if (merged == rightValue && timestamp == rightTimestamp) {
            return right;
        }
        return new BufferCell(left.column(), timestamp, 0, Long.MAX_VALUE, merged, left.path());
    }

    public static void addNonShadowed(Cell<?> existing, Cell<?> update, DeletionTime deletion, Row.Builder builder) {
        if (deletion.deletes(existing)) {
            return;
        }
        Cell<?> reconciled = Cells.reconcile(existing, update);
        if (reconciled != update) {
            builder.addCell(existing);
        }
    }

    public static void addNonShadowedComplex(ColumnMetadata column, Iterator<Cell<?>> existing, Iterator<Cell<?>> update, DeletionTime deletion, Row.Builder builder) {
        Comparator<CellPath> comparator = column.cellPathComparator();
        Cell<?> nextExisting = Cells.getNext(existing);
        Cell<?> nextUpdate = Cells.getNext(update);
        while (nextExisting != null) {
            int cmp;
            int n = cmp = nextUpdate == null ? -1 : comparator.compare(nextExisting.path(), nextUpdate.path());
            if (cmp < 0) {
                Cells.addNonShadowed(nextExisting, null, deletion, builder);
                nextExisting = Cells.getNext(existing);
                continue;
            }
            if (cmp == 0) {
                Cells.addNonShadowed(nextExisting, nextUpdate, deletion, builder);
                nextExisting = Cells.getNext(existing);
                nextUpdate = Cells.getNext(update);
                continue;
            }
            nextUpdate = Cells.getNext(update);
        }
    }

    private static Cell<?> getNext(Iterator<Cell<?>> iterator) {
        return iterator == null || !iterator.hasNext() ? null : iterator.next();
    }

    private static <L, R> int compareValues(Cell<L> left, Cell<R> right) {
        return ValueAccessor.compare(left.value(), left.accessor(), right.value(), right.accessor());
    }

    public static <L, R> boolean valueEqual(Cell<L> left, Cell<R> right) {
        return ValueAccessor.equals(left.value(), left.accessor(), right.value(), right.accessor());
    }

    public static <T, V> T composeValue(Cell<V> cell, AbstractType<T> type) {
        return type.compose(cell.value(), cell.accessor());
    }

    public static <V> String valueString(Cell<V> cell, AbstractType<?> type) {
        return type.getString(cell.value(), cell.accessor());
    }

    public static <V> String valueString(Cell<V> cell) {
        return Cells.valueString(cell, cell.column().type);
    }
}

