/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import org.apache.zookeeper.CreateMode;

public enum EphemeralType {
    VOID,
    NORMAL,
    CONTAINER,
    TTL;

    public static final long CONTAINER_EPHEMERAL_OWNER = Long.MIN_VALUE;
    public static final long MAX_TTL = 0xFFFFFFFFFFFFFFFL;
    public static final long TTL_MASK = Long.MIN_VALUE;

    public static EphemeralType get(long ephemeralOwner) {
        if (ephemeralOwner == Long.MIN_VALUE) {
            return CONTAINER;
        }
        if (ephemeralOwner < 0L) {
            return TTL;
        }
        return ephemeralOwner == 0L ? VOID : NORMAL;
    }

    public static void validateTTL(CreateMode mode, long ttl) {
        if (mode.isTTL()) {
            EphemeralType.ttlToEphemeralOwner(ttl);
        } else if (ttl >= 0L) {
            throw new IllegalArgumentException("ttl not valid for mode: " + (Object)((Object)mode));
        }
    }

    public static long getTTL(long ephemeralOwner) {
        if (ephemeralOwner < 0L && ephemeralOwner != Long.MIN_VALUE) {
            return ephemeralOwner & 0xFFFFFFFFFFFFFFFL;
        }
        return 0L;
    }

    public static long ttlToEphemeralOwner(long ttl) {
        if (ttl > 0xFFFFFFFFFFFFFFFL || ttl <= 0L) {
            throw new IllegalArgumentException("ttl must be positive and cannot be larger than: 1152921504606846975");
        }
        return Long.MIN_VALUE | ttl;
    }
}

