/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ServerIdTest
extends ClientBase {
    public static Stream<Arguments> data() throws Exception {
        ArrayList<Arguments> testTypes = new ArrayList<Arguments>();
        for (boolean ttlsEnabled : new boolean[]{true, false}) {
            for (int serverId = 0; serverId <= 255; ++serverId) {
                testTypes.add(Arguments.of((Object[])new Object[]{ttlsEnabled, serverId}));
            }
        }
        return testTypes.stream();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("zookeeper.extendedTypesEnabled");
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
    }

    public void setUp(boolean ttlsEnabled, int serverId) throws Exception {
        System.setProperty("zookeeper.extendedTypesEnabled", Boolean.toString(ttlsEnabled));
        LOG.info("ttlsEnabled: {} - ServerId: {}", (Object)ttlsEnabled, (Object)serverId);
        try {
            super.setUpWithServerId(serverId);
        }
        catch (RuntimeException e) {
            if (ttlsEnabled && (long)serverId >= 254L) {
                return;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void doTest(boolean ttlsEnabled, int serverId) throws Exception {
        this.setUp(ttlsEnabled, serverId);
        if (ttlsEnabled && (long)serverId >= 254L) {
            return;
        }
        try (TestableZooKeeper zk = null;){
            zk = this.createClient();
            zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.delete("/foo", -1);
            if (ttlsEnabled) {
                zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, new Stat(), 1000L);
            } else {
                try {
                    zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, new Stat(), 1000L);
                    Assertions.fail((String)"Should have thrown KeeperException.UnimplementedException");
                }
                catch (KeeperException.UnimplementedException unimplementedException) {
                    // empty catch block
                }
            }
        }
    }
}

