/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.MultiOperationRecord;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiOperationRecordTest
extends ZKTestCase {
    @Test
    public void testRoundTrip() throws IOException {
        MultiOperationRecord request = new MultiOperationRecord();
        request.add(Op.check((String)"check", (int)1));
        request.add(Op.create((String)"create", (byte[])"create data".getBytes(), (List)ZooDefs.Ids.CREATOR_ALL_ACL, (int)CreateMode.EPHEMERAL.toFlag()));
        request.add(Op.delete((String)"delete", (int)17));
        request.add(Op.setData((String)"setData", (byte[])"set data".getBytes(), (int)19));
        MultiOperationRecord decodedRequest = this.codeDecode(request);
        Assertions.assertEquals((Object)request, (Object)decodedRequest);
        Assertions.assertEquals((int)request.hashCode(), (int)decodedRequest.hashCode());
    }

    @Test
    public void testEmptyRoundTrip() throws IOException {
        MultiOperationRecord request = new MultiOperationRecord();
        MultiOperationRecord decodedRequest = this.codeDecode(request);
        Assertions.assertEquals((Object)request, (Object)decodedRequest);
        Assertions.assertEquals((int)request.hashCode(), (int)decodedRequest.hashCode());
    }

    private MultiOperationRecord codeDecode(MultiOperationRecord request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        request.serialize((OutputArchive)boa, "request");
        baos.close();
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        bb.rewind();
        BinaryInputArchive bia = BinaryInputArchive.getArchive((InputStream)new ByteBufferInputStream(bb));
        MultiOperationRecord decodedRequest = new MultiOperationRecord();
        decodedRequest.deserialize((InputArchive)bia, "request");
        return decodedRequest;
    }
}

