/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.dataflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.common.impls.NoOpPageWriteCallbackFactory;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IStorageManager;

public abstract class LsmResource
implements IResource {
    private static final long serialVersionUID = 2L;
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected String path;
    protected final IStorageManager storageManager;
    protected final ITypeTraits[] typeTraits;
    protected final IBinaryComparatorFactory[] cmpFactories;
    protected final ITypeTraits[] filterTypeTraits;
    protected final IBinaryComparatorFactory[] filterCmpFactories;
    protected final int[] filterFields;
    protected final ILSMOperationTrackerFactory opTrackerProvider;
    protected final ILSMIOOperationCallbackFactory ioOpCallbackFactory;
    protected final ILSMPageWriteCallbackFactory pageWriteCallbackFactory;
    protected final IMetadataPageManagerFactory metadataPageManagerFactory;
    protected final IVirtualBufferCacheProvider vbcProvider;
    protected final ILSMIOOperationSchedulerProvider ioSchedulerProvider;
    protected final ILSMMergePolicyFactory mergePolicyFactory;
    protected final Map<String, String> mergePolicyProperties;
    protected final boolean durable;
    protected final ITypeTraits nullTypeTraits;
    protected final INullIntrospector nullIntrospector;

    public LsmResource(String path, IStorageManager storageManager, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] filterFields, ILSMOperationTrackerFactory opTrackerProvider, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, IMetadataPageManagerFactory metadataPageManagerFactory, IVirtualBufferCacheProvider vbcProvider, ILSMIOOperationSchedulerProvider ioSchedulerProvider, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, boolean durable, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) {
        this.path = path;
        this.storageManager = storageManager;
        this.typeTraits = typeTraits;
        this.cmpFactories = cmpFactories;
        this.filterTypeTraits = filterTypeTraits;
        this.filterCmpFactories = filterCmpFactories;
        this.filterFields = filterFields;
        this.opTrackerProvider = opTrackerProvider;
        this.ioOpCallbackFactory = ioOpCallbackFactory;
        this.pageWriteCallbackFactory = pageWriteCallbackFactory;
        this.metadataPageManagerFactory = metadataPageManagerFactory;
        this.vbcProvider = vbcProvider;
        this.ioSchedulerProvider = ioSchedulerProvider;
        this.mergePolicyFactory = mergePolicyFactory;
        this.mergePolicyProperties = mergePolicyProperties;
        this.durable = durable;
        this.nullTypeTraits = nullTypeTraits;
        this.nullIntrospector = nullIntrospector;
    }

    protected LsmResource(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        this.path = json.get("path").asText();
        this.storageManager = (IStorageManager)registry.deserialize(json.get("storageManager"));
        ArrayList<ITypeTraits> typeTraitsList = new ArrayList<ITypeTraits>();
        ArrayNode jsonTypeTraits = (ArrayNode)json.get("typeTraits");
        for (JsonNode tt : jsonTypeTraits) {
            typeTraitsList.add((ITypeTraits)registry.deserialize(tt));
        }
        this.typeTraits = typeTraitsList.toArray(new ITypeTraits[0]);
        ArrayList<IBinaryComparatorFactory> cmpFactoriesList = new ArrayList<IBinaryComparatorFactory>();
        ArrayNode jsonCmpFactories = (ArrayNode)json.get("cmpFactories");
        for (JsonNode cf : jsonCmpFactories) {
            cmpFactoriesList.add((IBinaryComparatorFactory)registry.deserialize(cf));
        }
        this.cmpFactories = cmpFactoriesList.toArray(new IBinaryComparatorFactory[0]);
        if (json.hasNonNull("filterTypeTraits")) {
            ArrayList<ITypeTraits> filterTypeTraitsList = new ArrayList<ITypeTraits>();
            ArrayNode jsonFilterTypeTraits = (ArrayNode)json.get("filterTypeTraits");
            for (JsonNode tt : jsonFilterTypeTraits) {
                filterTypeTraitsList.add((ITypeTraits)registry.deserialize(tt));
            }
            this.filterTypeTraits = filterTypeTraitsList.toArray(new ITypeTraits[0]);
        } else {
            this.filterTypeTraits = null;
        }
        if (json.hasNonNull("filterCmpFactories")) {
            ArrayList<IBinaryComparatorFactory> filterCmpFactoriesList = new ArrayList<IBinaryComparatorFactory>();
            ArrayNode jsonFilterCmpFactories = (ArrayNode)json.get("filterCmpFactories");
            for (JsonNode cf : jsonFilterCmpFactories) {
                filterCmpFactoriesList.add((IBinaryComparatorFactory)registry.deserialize(cf));
            }
            this.filterCmpFactories = filterCmpFactoriesList.toArray(new IBinaryComparatorFactory[0]);
        } else {
            this.filterCmpFactories = null;
        }
        this.filterFields = (int[])OBJECT_MAPPER.convertValue((Object)json.get("filterFields"), int[].class);
        this.opTrackerProvider = (ILSMOperationTrackerFactory)registry.deserialize(json.get("opTrackerProvider"));
        this.ioOpCallbackFactory = (ILSMIOOperationCallbackFactory)registry.deserialize(json.get("ioOpCallbackFactory"));
        this.pageWriteCallbackFactory = json.has("pageWriteCallbackFactory") ? (ILSMPageWriteCallbackFactory)registry.deserialize(json.get("pageWriteCallbackFactory")) : NoOpPageWriteCallbackFactory.INSTANCE;
        this.metadataPageManagerFactory = (IMetadataPageManagerFactory)registry.deserialize(json.get("metadataPageManagerFactory"));
        this.vbcProvider = json.hasNonNull("vbcProvider") ? (IVirtualBufferCacheProvider)registry.deserialize(json.get("vbcProvider")) : null;
        this.ioSchedulerProvider = (ILSMIOOperationSchedulerProvider)registry.deserialize(json.get("ioSchedulerProvider"));
        this.mergePolicyFactory = (ILSMMergePolicyFactory)registry.deserialize(json.get("mergePolicyFactory"));
        this.mergePolicyProperties = (Map)OBJECT_MAPPER.convertValue((Object)json.get("mergePolicyProperties"), Map.class);
        this.durable = json.get("durable").asBoolean();
        this.nullTypeTraits = json.hasNonNull("nullTypeTraits") ? (ITypeTraits)registry.deserialize(json.get("nullTypeTraits")) : null;
        this.nullIntrospector = json.hasNonNull("nullIntrospector") ? (INullIntrospector)registry.deserialize(json.get("nullIntrospector")) : null;
    }

    protected void appendToJson(ObjectNode json, IPersistedResourceRegistry registry) throws HyracksDataException {
        json.put("path", this.path);
        json.set("storageManager", this.storageManager.toJson(registry));
        ArrayNode ttArray = OBJECT_MAPPER.createArrayNode();
        for (ITypeTraits tt : this.typeTraits) {
            ttArray.add(tt.toJson(registry));
        }
        json.set("typeTraits", (JsonNode)ttArray);
        ArrayNode cmpArray = OBJECT_MAPPER.createArrayNode();
        for (IBinaryComparatorFactory factory : this.cmpFactories) {
            cmpArray.add(factory.toJson(registry));
        }
        json.set("cmpFactories", (JsonNode)cmpArray);
        if (this.filterTypeTraits != null) {
            ArrayNode fttArray = OBJECT_MAPPER.createArrayNode();
            for (ITypeTraits tt : this.filterTypeTraits) {
                fttArray.add(tt.toJson(registry));
            }
            json.set("filterTypeTraits", (JsonNode)fttArray);
        } else {
            json.set("filterTypeTraits", null);
        }
        if (this.filterCmpFactories != null) {
            ArrayNode filterCmpArray = OBJECT_MAPPER.createArrayNode();
            for (IBinaryComparatorFactory factory : this.filterCmpFactories) {
                filterCmpArray.add(factory.toJson(registry));
            }
            json.set("filterCmpFactories", (JsonNode)filterCmpArray);
        } else {
            json.set("filterCmpFactories", null);
        }
        json.putPOJO("filterFields", (Object)this.filterFields);
        json.set("opTrackerProvider", this.opTrackerProvider.toJson(registry));
        json.set("ioOpCallbackFactory", this.ioOpCallbackFactory.toJson(registry));
        json.set("pageWriteCallbackFactory", this.pageWriteCallbackFactory.toJson(registry));
        json.set("metadataPageManagerFactory", this.metadataPageManagerFactory.toJson(registry));
        if (this.vbcProvider != null) {
            json.set("vbcProvider", this.vbcProvider.toJson(registry));
        }
        json.set("ioSchedulerProvider", this.ioSchedulerProvider.toJson(registry));
        json.set("mergePolicyFactory", this.mergePolicyFactory.toJson(registry));
        json.putPOJO("mergePolicyProperties", this.mergePolicyProperties);
        json.put("durable", this.durable);
        if (this.nullTypeTraits != null) {
            json.set("nullTypeTraits", this.nullTypeTraits.toJson(registry));
        } else {
            json.set("nullTypeTraits", null);
        }
        if (this.nullIntrospector != null) {
            json.set("nullIntrospector", this.nullIntrospector.toJson(registry));
        } else {
            json.set("nullIntrospector", null);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

