/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import java.io.Serializable;
import org.apache.asterix.formats.nontagged.OrderedLinearizeComparatorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.data.ILinearizeComparatorFactoryProvider;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.storage.am.rtree.linearize.HilbertDoubleComparatorFactory;
import org.apache.hyracks.storage.am.rtree.linearize.ZCurveDoubleComparatorFactory;
import org.apache.hyracks.storage.am.rtree.linearize.ZCurveIntComparatorFactory;

public class LinearizeComparatorFactoryProvider
implements ILinearizeComparatorFactoryProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final LinearizeComparatorFactoryProvider INSTANCE = new LinearizeComparatorFactoryProvider();

    private LinearizeComparatorFactoryProvider() {
    }

    public ILinearizeComparatorFactory getLinearizeComparatorFactory(Object type, boolean ascending, int dimension) throws AlgebricksException {
        ATypeTag typeTag = (ATypeTag)type;
        if (dimension == 2 && typeTag == ATypeTag.DOUBLE) {
            return this.addOffset((IBinaryComparatorFactory)new HilbertDoubleComparatorFactory(2), ascending);
        }
        if (typeTag == ATypeTag.DOUBLE) {
            return this.addOffset((IBinaryComparatorFactory)new ZCurveDoubleComparatorFactory(dimension), ascending);
        }
        if (typeTag == ATypeTag.TINYINT || typeTag == ATypeTag.SMALLINT || typeTag == ATypeTag.INTEGER || typeTag == ATypeTag.BIGINT) {
            return this.addOffset((IBinaryComparatorFactory)new ZCurveIntComparatorFactory(dimension), ascending);
        }
        throw new AlgebricksException("Cannot propose linearizer for key with type " + typeTag + " and dimension " + dimension + ".");
    }

    private ILinearizeComparatorFactory addOffset(IBinaryComparatorFactory inst, boolean ascending) {
        return new OrderedLinearizeComparatorFactory(inst, ascending);
    }
}

