/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.tuples;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleReference;
import org.apache.hyracks.storage.am.common.util.BitOperationUtils;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

public class TypeAwareTupleWriter
implements ITreeIndexTupleWriter {
    protected final ITypeTraits[] typeTraits;
    protected final ITypeTraits nullTypeTraits;
    protected final INullIntrospector nullIntrospector;

    public TypeAwareTupleWriter(ITypeTraits[] typeTraits, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) {
        this.typeTraits = typeTraits;
        this.nullTypeTraits = nullTypeTraits;
        this.nullIntrospector = nullIntrospector;
    }

    @Override
    public int bytesRequired(ITupleReference tuple) {
        int bytes = this.getNullFlagsBytes(tuple) + this.getFieldSlotsBytes(tuple);
        for (int i = 0; i < tuple.getFieldCount(); ++i) {
            bytes += tuple.getFieldLength(i);
        }
        return bytes;
    }

    @Override
    public int bytesRequired(ITupleReference tuple, int startField, int numFields) {
        int bytes = this.getNullFlagsBytes(numFields) + this.getFieldSlotsBytes(tuple, startField, numFields);
        for (int i = startField; i < startField + numFields; ++i) {
            bytes += tuple.getFieldLength(i);
        }
        return bytes;
    }

    @Override
    public TypeAwareTupleReference createTupleReference() {
        return new TypeAwareTupleReference(this.typeTraits, this.nullTypeTraits);
    }

    @Override
    public int writeTuple(ITupleReference tuple, ByteBuffer targetBuf, int targetOff) {
        return this.writeTuple(tuple, targetBuf.array(), targetOff);
    }

    @Override
    public int writeTuple(ITupleReference tuple, byte[] targetBuf, int targetOff) {
        int i;
        int runner = targetOff;
        int nullFlagsBytes = this.getNullFlagsBytes(tuple);
        for (i = 0; i < nullFlagsBytes; ++i) {
            targetBuf[runner++] = 0;
        }
        for (i = 0; i < tuple.getFieldCount(); ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            runner += VarLenIntEncoderDecoder.encode((int)tuple.getFieldLength(i), (byte[])targetBuf, (int)runner);
        }
        for (i = 0; i < tuple.getFieldCount(); ++i) {
            byte[] fieldData = tuple.getFieldData(i);
            int fieldOffset = tuple.getFieldStart(i);
            int fieldLength = tuple.getFieldLength(i);
            if (this.nullIntrospector != null && this.nullIntrospector.isNull(fieldData, fieldOffset, fieldLength)) {
                this.setNullFlag(targetBuf, targetOff, i);
            }
            System.arraycopy(fieldData, fieldOffset, targetBuf, runner, fieldLength);
            runner += fieldLength;
        }
        return runner - targetOff;
    }

    @Override
    public int writeTupleFields(ITupleReference tuple, int startField, int numFields, byte[] targetBuf, int targetOff) {
        int i;
        int runner = targetOff;
        int nullFlagsBytes = this.getNullFlagsBytes(numFields);
        for (i = 0; i < nullFlagsBytes; ++i) {
            targetBuf[runner++] = 0;
        }
        for (i = startField; i < startField + numFields; ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            runner += VarLenIntEncoderDecoder.encode((int)tuple.getFieldLength(i), (byte[])targetBuf, (int)runner);
        }
        i = startField;
        int targetField = 0;
        while (i < startField + numFields) {
            byte[] fieldData = tuple.getFieldData(i);
            int fieldOffset = tuple.getFieldStart(i);
            int fieldLength = tuple.getFieldLength(i);
            if (this.nullIntrospector != null && this.nullIntrospector.isNull(fieldData, fieldOffset, fieldLength)) {
                this.setNullFlag(targetBuf, targetOff, targetField);
            }
            System.arraycopy(fieldData, fieldOffset, targetBuf, runner, fieldLength);
            runner += fieldLength;
            ++i;
            ++targetField;
        }
        return runner - targetOff;
    }

    protected int getNullFlagsBytes(ITupleReference tuple) {
        return BitOperationUtils.getFlagBytes(tuple.getFieldCount());
    }

    protected int getFieldSlotsBytes(ITupleReference tuple) {
        int fieldSlotBytes = 0;
        for (int i = 0; i < tuple.getFieldCount(); ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            fieldSlotBytes += VarLenIntEncoderDecoder.getBytesRequired((int)tuple.getFieldLength(i));
        }
        return fieldSlotBytes;
    }

    protected int getNullFlagsBytes(int numFields) {
        return BitOperationUtils.getFlagBytes(numFields);
    }

    protected int getFieldSlotsBytes(ITupleReference tuple, int startField, int numFields) {
        int fieldSlotBytes = 0;
        for (int i = startField; i < startField + numFields; ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            fieldSlotBytes += VarLenIntEncoderDecoder.getBytesRequired((int)tuple.getFieldLength(i));
        }
        return fieldSlotBytes;
    }

    public ITypeTraits[] getTypeTraits() {
        return this.typeTraits;
    }

    public ITypeTraits getNullTypeTraits() {
        return this.nullTypeTraits;
    }

    public INullIntrospector getNullIntrospector() {
        return this.nullIntrospector;
    }

    @Override
    public int getCopySpaceRequired(ITupleReference tuple) {
        return this.bytesRequired(tuple);
    }

    protected void setNullFlag(byte[] flags, int flagsOffset, int fieldIdx) {
        int adjustedFieldIdx = this.getAdjustedFieldIdx(fieldIdx);
        int flagByteIdx = adjustedFieldIdx / 8;
        int flagBitIdx = 7 - adjustedFieldIdx % 8;
        BitOperationUtils.setBit(flags, flagsOffset + flagByteIdx, (byte)flagBitIdx);
    }

    protected int getAdjustedFieldIdx(int fieldIdx) {
        return fieldIdx;
    }
}

