/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.distribution;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.Resources;
import com.teradata.tpcds.TpcdsException;
import com.teradata.tpcds.random.RandomNumberStream;
import com.teradata.tpcds.random.RandomValueGenerator;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class DistributionUtils {
    private DistributionUtils() {
    }

    protected static Iterator<List<String>> getDistributionIterator(String filename) {
        URL resource = Resources.getResource(DistributionUtils.class, (String)filename);
        Preconditions.checkState((resource != null ? 1 : 0) != 0, (String)"Distribution file '%s' not found", (Object[])new Object[]{filename});
        try {
            return Iterators.transform((Iterator)Iterators.filter((Iterator)Resources.asCharSource((URL)resource, (Charset)StandardCharsets.ISO_8859_1).readLines().iterator(), line -> !(line = line.trim()).isEmpty() && !line.startsWith("--")), line -> ImmutableList.copyOf((Iterable)Splitter.on((Pattern)Pattern.compile("(?<!\\\\):")).trimResults().split((CharSequence)line)));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected static List<String> getListFromCommaSeparatedValues(String toSplit) {
        List values = Splitter.on((Pattern)Pattern.compile("(?<!\\\\),")).trimResults().splitToList((CharSequence)toSplit);
        return values.stream().map(value -> value.replaceAll("\\\\", "")).collect(Collectors.toList());
    }

    protected static <T> T pickRandomValue(List<T> values, List<Integer> weights, RandomNumberStream randomNumberStream) {
        int weight = RandomValueGenerator.generateUniformRandomInt(1, weights.get(weights.size() - 1), randomNumberStream);
        return DistributionUtils.getValueForWeight(weight, values, weights);
    }

    private static <T> T getValueForWeight(int weight, List<T> values, List<Integer> weights) {
        Preconditions.checkArgument((values.size() == weights.size() ? 1 : 0) != 0);
        for (int index = 0; index < weights.size(); ++index) {
            if (weight > weights.get(index)) continue;
            return values.get(index);
        }
        throw new TpcdsException("random weight was greater than max weight");
    }

    protected static <T> T getValueForIndexModSize(long index, List<T> values) {
        int size = values.size();
        int indexModSize = (int)(index % (long)size);
        return values.get(indexModSize);
    }

    protected static int pickRandomIndex(List<Integer> weights, RandomNumberStream randomNumberStream) {
        int weight = RandomValueGenerator.generateUniformRandomInt(1, weights.get(weights.size() - 1), randomNumberStream);
        return DistributionUtils.getIndexForWeight(weight, weights);
    }

    private static int getIndexForWeight(int weight, List<Integer> weights) {
        for (int index = 0; index < weights.size(); ++index) {
            if (weight > weights.get(index)) continue;
            return index;
        }
        throw new TpcdsException("random weight was greater than max weight");
    }

    protected static int getWeightForIndex(int index, List<Integer> weights) {
        Preconditions.checkArgument((index < weights.size() ? 1 : 0) != 0, (Object)"index larger than distribution");
        return index == 0 ? weights.get(index) : weights.get(index) - weights.get(index - 1);
    }

    protected static final class WeightsBuilder {
        ImmutableList.Builder<Integer> weightsBuilder = ImmutableList.builder();
        int previousWeight = 0;

        protected WeightsBuilder() {
        }

        public WeightsBuilder computeAndAddNextWeight(int weight) {
            Preconditions.checkArgument((weight >= 0 ? 1 : 0) != 0, (Object)"Weight cannot be negative.");
            int newWeight = this.previousWeight + weight;
            this.weightsBuilder.add((Object)newWeight);
            this.previousWeight = newWeight;
            return this;
        }

        public ImmutableList<Integer> build() {
            return this.weightsBuilder.build();
        }
    }
}

