/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import com.esri.core.geometry.ogc.OGCMultiLineString;
import org.apache.asterix.geo.evaluators.functions.AbstractSTSingleGeometryDescriptor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class STLengthDescriptor
extends AbstractSTSingleGeometryDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = STLengthDescriptor::new;

    @Override
    protected Object evaluateOGCGeometry(OGCGeometry geometry) throws HyracksDataException {
        if (geometry instanceof OGCLineString) {
            return geometry.getEsriGeometry().calculateLength2D();
        }
        if (geometry instanceof OGCMultiLineString) {
            GeometryCursor cursor = geometry.getEsriGeometryCursor();
            double length = 0.0;
            Geometry geometry1 = cursor.next();
            while (geometry1 != null) {
                length += geometry1.calculateLength2D();
                geometry1 = cursor.next();
            }
            return length;
        }
        throw new UnsupportedOperationException("The operation " + this.getIdentifier() + " is not supported for the type " + geometry.geometryType());
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_LENGTH;
    }
}

