/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CLFLogger
extends ChannelDuplexHandler {
    private static final Logger accessLogger = LogManager.getLogger();
    private static final Level ACCESS_LOG_LEVEL = Level.forName((String)"ACCESS", (int)550);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z").withZone(ZoneId.systemDefault());
    private StringBuilder logLineBuilder = new StringBuilder();
    private String clientIp;
    private Instant requestTime;
    private String reqLine;
    private int statusCode;
    private long respSize = 0L;
    private String userAgentRef;
    private boolean lastChunk = false;

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            this.clientIp = ((NioSocketChannel)ctx.channel()).remoteAddress().getAddress().toString().substring(1);
            this.requestTime = Instant.now();
            this.reqLine = req.method().toString() + " " + req.getUri() + " " + req.getProtocolVersion().toString();
            this.userAgentRef = this.headerValueOrDash("Referer", req) + " " + this.headerValueOrDash("User-Agent", req);
            this.lastChunk = false;
        }
        ctx.fireChannelRead(msg);
    }

    private String headerValueOrDash(String headerKey, HttpRequest req) {
        String value = req.headers().get(headerKey);
        value = value == null ? "-" : "\"" + value + "\"";
        return value;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof DefaultHttpResponse) {
            DefaultHttpResponse resp = (DefaultHttpResponse)msg;
            this.statusCode = resp.status().code();
            if (msg instanceof DefaultFullHttpResponse) {
                this.lastChunk = true;
                this.respSize = resp.headers().getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            }
        } else if (msg instanceof DefaultHttpContent) {
            DefaultHttpContent content = (DefaultHttpContent)msg;
            this.respSize += (long)content.content().readableBytes();
        } else if (msg instanceof LastHttpContent) {
            this.lastChunk = true;
        }
        ctx.write(msg, promise);
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.lastChunk) {
            this.printAndPrepare();
            this.lastChunk = false;
        }
        ctx.flush();
    }

    private void printAndPrepare() {
        if (!accessLogger.isEnabled(ACCESS_LOG_LEVEL)) {
            return;
        }
        this.logLineBuilder.append(this.clientIp);
        this.logLineBuilder.append(" - ");
        this.logLineBuilder.append(" - [");
        this.logLineBuilder.append(DATE_TIME_FORMATTER.format(this.requestTime));
        this.logLineBuilder.append("] \"");
        this.logLineBuilder.append(this.reqLine);
        this.logLineBuilder.append("\"");
        this.logLineBuilder.append(" ").append(this.statusCode);
        this.logLineBuilder.append(" ").append(this.respSize);
        this.logLineBuilder.append(" ").append(this.userAgentRef);
        accessLogger.log(ACCESS_LOG_LEVEL, (CharSequence)this.logLineBuilder);
        this.respSize = 0L;
        this.logLineBuilder.setLength(0);
    }
}

