/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalOperatorDeepCopyWithNewVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public abstract class PushMapOperatorThroughUnionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    protected boolean isOperatorKindPushableThroughUnion(ILogicalOperator op) {
        return op.isMap();
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean pushable;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        boolean bl = pushable = this.isOperatorKindPushableThroughUnion((ILogicalOperator)op) && OperatorPropertiesUtil.isMovable((ILogicalOperator)op);
        if (!pushable) {
            return false;
        }
        Mutable inputOpRef = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator inputOp = (AbstractLogicalOperator)inputOpRef.getValue();
        if (inputOp.getOperatorTag() != LogicalOperatorTag.UNIONALL) {
            return false;
        }
        UnionAllOperator unionAllOp = (UnionAllOperator)inputOp;
        ArrayList opProducedVars = new ArrayList();
        VariableUtilities.getProducedVariables((ILogicalOperator)op, opProducedVars);
        HashSet<LogicalVariable> opUsedVars = new HashSet<LogicalVariable>();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, opUsedVars);
        Pair<ILogicalOperator, Map<LogicalVariable, LogicalVariable>> leftBranchPair = this.insertIntoBranch(op, opUsedVars, unionAllOp, 0, context);
        if (leftBranchPair == null) {
            return false;
        }
        ILogicalOperator leftBranchRootOp = (ILogicalOperator)leftBranchPair.first;
        Map leftBranchProducedVarMap = (Map)leftBranchPair.second;
        Pair<ILogicalOperator, Map<LogicalVariable, LogicalVariable>> rightBranchPair = this.insertIntoBranch(op, opUsedVars, unionAllOp, 1, context);
        if (rightBranchPair == null) {
            return false;
        }
        ILogicalOperator rightBranchRootOp = (ILogicalOperator)rightBranchPair.first;
        Map rightBranchProducedVarMap = (Map)rightBranchPair.second;
        UnionAllOperator newUnionAllOp = (UnionAllOperator)OperatorManipulationUtil.deepCopy((ILogicalOperator)unionAllOp);
        newUnionAllOp.getInputs().add(new MutableObject((Object)leftBranchRootOp));
        newUnionAllOp.getInputs().add(new MutableObject((Object)rightBranchRootOp));
        for (LogicalVariable opProducedVar : opProducedVars) {
            LogicalVariable leftBranchProducedVar = (LogicalVariable)leftBranchProducedVarMap.get(opProducedVar);
            if (leftBranchProducedVar == null) {
                throw AlgebricksException.create((int)10009, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{"Cannot find " + opProducedVar});
            }
            LogicalVariable rightBranchProducedVar = (LogicalVariable)rightBranchProducedVarMap.get(opProducedVar);
            if (rightBranchProducedVar == null) {
                throw AlgebricksException.create((int)10009, (SourceLocation)op.getSourceLocation(), (Serializable[])new Serializable[]{"Cannot find " + opProducedVar});
            }
            newUnionAllOp.getVariableMappings().add(new Triple((Object)leftBranchProducedVar, (Object)rightBranchProducedVar, (Object)opProducedVar));
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newUnionAllOp);
        opRef.setValue((Object)newUnionAllOp);
        return true;
    }

    private Pair<ILogicalOperator, Map<LogicalVariable, LogicalVariable>> insertIntoBranch(AbstractLogicalOperator op, Set<LogicalVariable> opUsedVars, UnionAllOperator unionAllOp, int branchIdx, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator branchRootOp = (ILogicalOperator)((Mutable)unionAllOp.getInputs().get(branchIdx)).getValue();
        Pair<ILogicalOperator, Map<LogicalVariable, LogicalVariable>> newBranchRootOpPair = this.deepCopyForBranch((ILogicalOperator)op, opUsedVars, unionAllOp, branchIdx, context);
        if (newBranchRootOpPair == null) {
            return null;
        }
        ILogicalOperator newBranchRootOp = (ILogicalOperator)newBranchRootOpPair.first;
        ((Mutable)newBranchRootOp.getInputs().get(0)).setValue((Object)branchRootOp);
        context.computeAndSetTypeEnvironmentForOperator(newBranchRootOp);
        return newBranchRootOpPair;
    }

    protected Pair<ILogicalOperator, Map<LogicalVariable, LogicalVariable>> deepCopyForBranch(ILogicalOperator op, Set<LogicalVariable> opUsedVars, UnionAllOperator unionAllOp, int branchIdx, IOptimizationContext context) throws AlgebricksException {
        LinkedHashMap<LogicalVariable, LogicalVariable> usedVarsMapping = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        for (Triple t : unionAllOp.getVariableMappings()) {
            LogicalVariable unionOutputVar = (LogicalVariable)t.third;
            if (!opUsedVars.contains(unionOutputVar)) continue;
            LogicalVariable branchVar = branchIdx == 0 ? (LogicalVariable)t.first : (LogicalVariable)t.second;
            usedVarsMapping.put(unionOutputVar, branchVar);
        }
        LogicalOperatorDeepCopyWithNewVariablesVisitor deepCopyVisitor = new LogicalOperatorDeepCopyWithNewVariablesVisitor((IVariableContext)context, null, usedVarsMapping, true);
        ILogicalOperator newOp = deepCopyVisitor.deepCopy(op);
        return new Pair((Object)newOp, (Object)deepCopyVisitor.getInputToOutputVariableMapping());
    }
}

