/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.IsomorphismUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class IsomorphismOperatorVisitor
implements ILogicalOperatorVisitor<Boolean, ILogicalOperator> {
    private final Map<LogicalVariable, LogicalVariable> variableMapping = new HashMap<LogicalVariable, LogicalVariable>();

    @Override
    public Boolean visitAggregateOperator(AggregateOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return Boolean.FALSE;
        }
        AggregateOperator aggOpArg = (AggregateOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(this.getPairList(op.getVariables(), op.getExpressions()), this.getPairList(aggOpArg.getVariables(), aggOpArg.getExpressions()));
        return isomorphic;
    }

    @Override
    public Boolean visitRunningAggregateOperator(RunningAggregateOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.RUNNINGAGGREGATE) {
            return Boolean.FALSE;
        }
        RunningAggregateOperator aggOpArg = (RunningAggregateOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(this.getPairList(op.getVariables(), op.getExpressions()), this.getPairList(aggOpArg.getVariables(), aggOpArg.getExpressions()));
        return isomorphic;
    }

    @Override
    public Boolean visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)this.copyAndSubstituteVar(op, arg);
        if (aop.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitDelegateOperator(DelegateOperator op, ILogicalOperator arg) throws AlgebricksException {
        DelegateOperator aop = (DelegateOperator)this.copyAndSubstituteVar(op, arg);
        if (aop.getOperatorTag() != LogicalOperatorTag.DELEGATE_OPERATOR) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitGroupByOperator(GroupByOperator op, ILogicalOperator arg) throws AlgebricksException {
        int sizeArg;
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.GROUP || op.getPhysicalOperator() == null || aop.getPhysicalOperator() == null || op.getPhysicalOperator().getOperatorTag() != aop.getPhysicalOperator().getOperatorTag()) {
            return Boolean.FALSE;
        }
        List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> keyLists = op.getGroupByList();
        GroupByOperator gbyOpArg = (GroupByOperator)this.copyAndSubstituteVar(op, arg);
        List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> keyListsArg = gbyOpArg.getGroupByList();
        ArrayList<Pair> listLeft = new ArrayList<Pair>();
        ArrayList<Pair> listRight = new ArrayList<Pair>();
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> pair : keyLists) {
            listLeft.add(new Pair(pair.first, ((Mutable)pair.second).getValue()));
        }
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> pair : keyListsArg) {
            listRight.add(new Pair(pair.first, ((Mutable)pair.second).getValue()));
        }
        boolean isomorphic = VariableUtilities.varListEqualUnordered(listLeft, listRight);
        if (!isomorphic) {
            return Boolean.FALSE;
        }
        int sizeOp = op.getNestedPlans().size();
        if (sizeOp != (sizeArg = gbyOpArg.getNestedPlans().size())) {
            return Boolean.FALSE;
        }
        GroupByOperator argOp = (GroupByOperator)arg;
        List<ILogicalPlan> plans = op.getNestedPlans();
        List<ILogicalPlan> plansArg = argOp.getNestedPlans();
        for (int i = 0; i < plans.size(); ++i) {
            List<Mutable<ILogicalOperator>> roots = plans.get(i).getRoots();
            List<Mutable<ILogicalOperator>> rootsArg = plansArg.get(i).getRoots();
            if (roots.size() != rootsArg.size()) {
                return Boolean.FALSE;
            }
            for (int j = 0; j < roots.size(); ++j) {
                ILogicalOperator topOp2;
                ILogicalOperator topOp1 = (ILogicalOperator)roots.get(j).getValue();
                isomorphic = IsomorphismUtilities.isOperatorIsomorphicPlanSegment(topOp1, topOp2 = (ILogicalOperator)rootsArg.get(j).getValue());
                if (isomorphic) continue;
                return Boolean.FALSE;
            }
        }
        return isomorphic;
    }

    @Override
    public Boolean visitLimitOperator(LimitOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.LIMIT) {
            return Boolean.FALSE;
        }
        LimitOperator limitOpArg = (LimitOperator)this.copyAndSubstituteVar(op, arg);
        if (!Objects.equals(op.getOffset().getValue(), limitOpArg.getOffset().getValue())) {
            return Boolean.FALSE;
        }
        boolean isomorphic = ((ILogicalExpression)op.getMaxObjects().getValue()).equals(limitOpArg.getMaxObjects().getValue());
        return isomorphic;
    }

    @Override
    public Boolean visitInnerJoinOperator(InnerJoinOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return Boolean.FALSE;
        }
        InnerJoinOperator joinOpArg = (InnerJoinOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = ((ILogicalExpression)op.getCondition().getValue()).equals(joinOpArg.getCondition().getValue());
        return isomorphic;
    }

    @Override
    public Boolean visitLeftOuterJoinOperator(LeftOuterJoinOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            return Boolean.FALSE;
        }
        LeftOuterJoinOperator joinOpArg = (LeftOuterJoinOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = ((ILogicalExpression)op.getCondition().getValue()).equals(joinOpArg.getCondition().getValue());
        return isomorphic;
    }

    @Override
    public Boolean visitNestedTupleSourceOperator(NestedTupleSourceOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitOrderOperator(OrderOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.ORDER) {
            return Boolean.FALSE;
        }
        OrderOperator orderOpArg = (OrderOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = IsomorphismOperatorVisitor.compareIOrderAndExpressions(op.getOrderExpressions(), orderOpArg.getOrderExpressions());
        return isomorphic;
    }

    @Override
    public Boolean visitAssignOperator(AssignOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return Boolean.FALSE;
        }
        AssignOperator assignOpArg = (AssignOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(this.getPairList(op.getVariables(), op.getExpressions()), this.getPairList(assignOpArg.getVariables(), assignOpArg.getExpressions()));
        return isomorphic;
    }

    @Override
    public Boolean visitSelectOperator(SelectOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return Boolean.FALSE;
        }
        SelectOperator selectOpArg = (SelectOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = ((ILogicalExpression)op.getCondition().getValue()).equals(selectOpArg.getCondition().getValue());
        return isomorphic;
    }

    @Override
    public Boolean visitProjectOperator(ProjectOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.PROJECT) {
            return Boolean.FALSE;
        }
        ProjectOperator projectOpArg = (ProjectOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(op.getVariables(), projectOpArg.getVariables());
        return isomorphic;
    }

    @Override
    public Boolean visitReplicateOperator(ReplicateOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.REPLICATE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitSplitOperator(SplitOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.SPLIT) {
            return Boolean.FALSE;
        }
        SplitOperator sOpArg = (SplitOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = ((ILogicalExpression)op.getBranchingExpression().getValue()).equals(sOpArg.getBranchingExpression().getValue());
        return isomorphic;
    }

    @Override
    public Boolean visitMaterializeOperator(MaterializeOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.MATERIALIZE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitScriptOperator(ScriptOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.SCRIPT) {
            return Boolean.FALSE;
        }
        ScriptOperator scriptOpArg = (ScriptOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = op.getScriptDescription().equals(scriptOpArg.getScriptDescription());
        return isomorphic;
    }

    @Override
    public Boolean visitSubplanOperator(SubplanOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return Boolean.FALSE;
        }
        SubplanOperator subplanOpArg = (SubplanOperator)this.copyAndSubstituteVar(op, arg);
        List<ILogicalPlan> plans = op.getNestedPlans();
        List<ILogicalPlan> plansArg = subplanOpArg.getNestedPlans();
        for (int i = 0; i < plans.size(); ++i) {
            List<Mutable<ILogicalOperator>> roots = plans.get(i).getRoots();
            List<Mutable<ILogicalOperator>> rootsArg = plansArg.get(i).getRoots();
            if (roots.size() == rootsArg.size()) {
                return Boolean.FALSE;
            }
            for (int j = 0; j < roots.size(); ++j) {
                ILogicalOperator topOp2;
                ILogicalOperator topOp1 = (ILogicalOperator)roots.get(j).getValue();
                boolean isomorphic = IsomorphismUtilities.isOperatorIsomorphicPlanSegment(topOp1, topOp2 = (ILogicalOperator)rootsArg.get(j).getValue());
                if (isomorphic) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitUnionOperator(UnionAllOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.UNIONALL) {
            return Boolean.FALSE;
        }
        UnionAllOperator unionOpArg = (UnionAllOperator)this.copyAndSubstituteVar(op, arg);
        List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> mapping = op.getVariableMappings();
        List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> mappingArg = unionOpArg.getVariableMappings();
        if (mapping.size() != mappingArg.size()) {
            return Boolean.FALSE;
        }
        return VariableUtilities.varListEqualUnordered(mapping, mappingArg);
    }

    @Override
    public Boolean visitIntersectOperator(IntersectOperator op, ILogicalOperator arg) throws AlgebricksException {
        if (op.getOperatorTag() != LogicalOperatorTag.INTERSECT) {
            return Boolean.FALSE;
        }
        IntersectOperator intersetOpArg = (IntersectOperator)this.copyAndSubstituteVar(op, arg);
        List<LogicalVariable> outputCompareVars = op.getOutputCompareVariables();
        List<LogicalVariable> outputCompareVarsArg = intersetOpArg.getOutputCompareVariables();
        if (outputCompareVars.size() != outputCompareVarsArg.size()) {
            return Boolean.FALSE;
        }
        if (!VariableUtilities.varListEqualUnordered(outputCompareVars, outputCompareVarsArg)) {
            return Boolean.FALSE;
        }
        boolean hasExtraVars = op.hasExtraVariables();
        List<LogicalVariable> outputExtraVars = op.getOutputExtraVariables();
        List<LogicalVariable> outputExtraVarsArg = intersetOpArg.getOutputExtraVariables();
        if (outputExtraVars.size() != outputExtraVarsArg.size()) {
            return Boolean.FALSE;
        }
        if (!VariableUtilities.varListEqualUnordered(outputExtraVars, outputExtraVarsArg)) {
            return Boolean.FALSE;
        }
        int nInput = op.getNumInput();
        if (nInput != intersetOpArg.getNumInput()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < nInput; ++i) {
            if (!VariableUtilities.varListEqualUnordered(op.getInputCompareVariables(i), intersetOpArg.getInputCompareVariables(i))) {
                return Boolean.FALSE;
            }
            if (!hasExtraVars || VariableUtilities.varListEqualUnordered(op.getInputExtraVariables(i), intersetOpArg.getInputExtraVariables(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitUnnestOperator(UnnestOperator op, ILogicalOperator arg) throws AlgebricksException {
        boolean isomorphic;
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return Boolean.FALSE;
        }
        UnnestOperator unnestOpArg = (UnnestOperator)this.copyAndSubstituteVar(op, arg);
        boolean bl = isomorphic = VariableUtilities.varListEqualUnordered(op.getVariables(), unnestOpArg.getVariables()) && IsomorphismOperatorVisitor.variableEqual(op.getPositionalVariable(), unnestOpArg.getPositionalVariable());
        if (!isomorphic) {
            return Boolean.FALSE;
        }
        isomorphic = ((ILogicalExpression)op.getExpressionRef().getValue()).equals(unnestOpArg.getExpressionRef().getValue());
        return isomorphic;
    }

    @Override
    public Boolean visitUnnestMapOperator(UnnestMapOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.UNNEST_MAP) {
            return Boolean.FALSE;
        }
        UnnestMapOperator unnestOpArg = (UnnestMapOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(op.getVariables(), unnestOpArg.getVariables());
        if (!isomorphic) {
            return Boolean.FALSE;
        }
        isomorphic = ((ILogicalExpression)op.getExpressionRef().getValue()).equals(unnestOpArg.getExpressionRef().getValue());
        return isomorphic;
    }

    @Override
    public Boolean visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.LEFT_OUTER_UNNEST_MAP) {
            return Boolean.FALSE;
        }
        LeftOuterUnnestMapOperator loUnnestOpArg = (LeftOuterUnnestMapOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(op.getVariables(), loUnnestOpArg.getVariables());
        if (!isomorphic) {
            return Boolean.FALSE;
        }
        isomorphic = ((ILogicalExpression)op.getExpressionRef().getValue()).equals(loUnnestOpArg.getExpressionRef().getValue());
        return isomorphic;
    }

    @Override
    public Boolean visitDataScanOperator(DataSourceScanOperator op, ILogicalOperator arg) throws AlgebricksException {
        boolean isomorphic;
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
            return Boolean.FALSE;
        }
        DataSourceScanOperator argScan = (DataSourceScanOperator)arg;
        boolean bl = isomorphic = op.getDataSource().getId().equals(argScan.getDataSource().getId()) && op.getOutputLimit() == argScan.getOutputLimit();
        if (!isomorphic) {
            return Boolean.FALSE;
        }
        DataSourceScanOperator scanOpArg = (DataSourceScanOperator)this.copyAndSubstituteVar(op, arg);
        ILogicalExpression opCondition = op.getSelectCondition() != null ? (ILogicalExpression)op.getSelectCondition().getValue() : null;
        ILogicalExpression argCondition = scanOpArg.getSelectCondition() != null ? (ILogicalExpression)scanOpArg.getSelectCondition().getValue() : null;
        isomorphic = VariableUtilities.varListEqualUnordered(op.getVariables(), scanOpArg.getVariables()) && Objects.equals(opCondition, argCondition);
        return isomorphic;
    }

    @Override
    public Boolean visitDistinctOperator(DistinctOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.DISTINCT) {
            return Boolean.FALSE;
        }
        DistinctOperator distinctOpArg = (DistinctOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = IsomorphismOperatorVisitor.compareExpressions(op.getExpressions(), distinctOpArg.getExpressions());
        return isomorphic;
    }

    @Override
    public Boolean visitExchangeOperator(ExchangeOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.EXCHANGE) {
            return Boolean.FALSE;
        }
        if (op.getPhysicalOperator() == null || aop.getPhysicalOperator() == null || op.getPhysicalOperator().getOperatorTag() != aop.getPhysicalOperator().getOperatorTag()) {
            return Boolean.FALSE;
        }
        this.variableMapping.clear();
        IsomorphismUtilities.mapVariablesTopDown(op, arg, this.variableMapping);
        IPhysicalPropertiesVector properties = op.getPhysicalOperator().getDeliveredProperties();
        IPhysicalPropertiesVector propertiesArg = aop.getPhysicalOperator().getDeliveredProperties();
        if (properties == null && propertiesArg == null) {
            return Boolean.TRUE;
        }
        if (properties == null || propertiesArg == null) {
            return Boolean.FALSE;
        }
        IPartitioningProperty partProp = properties.getPartitioningProperty();
        IPartitioningProperty partPropArg = propertiesArg.getPartitioningProperty();
        if (!partProp.getPartitioningType().equals((Object)partPropArg.getPartitioningType())) {
            return Boolean.FALSE;
        }
        ArrayList<LogicalVariable> columns = new ArrayList<LogicalVariable>();
        partProp.getColumns(columns);
        ArrayList<LogicalVariable> columnsArg = new ArrayList<LogicalVariable>();
        partPropArg.getColumns(columnsArg);
        if (columns.size() != columnsArg.size()) {
            return Boolean.FALSE;
        }
        if (columns.size() == 0) {
            return Boolean.TRUE;
        }
        for (int i = 0; i < columnsArg.size(); ++i) {
            LogicalVariable rightVar = (LogicalVariable)columnsArg.get(i);
            LogicalVariable leftVar = this.variableMapping.get(rightVar);
            if (leftVar == null) continue;
            columnsArg.set(i, leftVar);
        }
        return columns.equals(columnsArg);
    }

    @Override
    public Boolean visitWriteOperator(WriteOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.WRITE) {
            return Boolean.FALSE;
        }
        WriteOperator writeOpArg = (WriteOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(op.getSchema(), writeOpArg.getSchema());
        return isomorphic;
    }

    @Override
    public Boolean visitDistributeResultOperator(DistributeResultOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return Boolean.FALSE;
        }
        DistributeResultOperator writeOpArg = (DistributeResultOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(op.getSchema(), writeOpArg.getSchema());
        return isomorphic;
    }

    @Override
    public Boolean visitWriteResultOperator(WriteResultOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.WRITE_RESULT) {
            return Boolean.FALSE;
        }
        WriteResultOperator writeOpArg = (WriteResultOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(op.getSchema(), writeOpArg.getSchema());
        if (!op.getDataSource().equals(writeOpArg.getDataSource())) {
            isomorphic = false;
        }
        if (!op.getPayloadExpression().equals(writeOpArg.getPayloadExpression())) {
            isomorphic = false;
        }
        return isomorphic;
    }

    @Override
    public Boolean visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.INSERT_DELETE_UPSERT) {
            return Boolean.FALSE;
        }
        InsertDeleteUpsertOperator insertOpArg = (InsertDeleteUpsertOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(op.getSchema(), insertOpArg.getSchema());
        if (!op.getDataSource().equals(insertOpArg.getDataSource())) {
            isomorphic = false;
        }
        if (!op.getPayloadExpression().equals(insertOpArg.getPayloadExpression())) {
            isomorphic = false;
        }
        return isomorphic;
    }

    @Override
    public Boolean visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.INDEX_INSERT_DELETE_UPSERT) {
            return Boolean.FALSE;
        }
        IndexInsertDeleteUpsertOperator insertOpArg = (IndexInsertDeleteUpsertOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(op.getSchema(), insertOpArg.getSchema());
        if (!op.getDataSourceIndex().equals(insertOpArg.getDataSourceIndex())) {
            isomorphic = false;
        }
        return isomorphic;
    }

    @Override
    public Boolean visitTokenizeOperator(TokenizeOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.TOKENIZE) {
            return Boolean.FALSE;
        }
        TokenizeOperator tokenizeOpArg = (TokenizeOperator)this.copyAndSubstituteVar(op, arg);
        boolean isomorphic = VariableUtilities.varListEqualUnordered(op.getSchema(), tokenizeOpArg.getSchema());
        if (!op.getDataSourceIndex().equals(tokenizeOpArg.getDataSourceIndex())) {
            isomorphic = false;
        }
        return isomorphic;
    }

    @Override
    public Boolean visitForwardOperator(ForwardOperator op, ILogicalOperator arg) throws AlgebricksException {
        ILogicalExpression otherRangeMapExp;
        AbstractLogicalOperator argOperator = (AbstractLogicalOperator)arg;
        if (argOperator.getOperatorTag() != LogicalOperatorTag.FORWARD) {
            return Boolean.FALSE;
        }
        ForwardOperator otherOp = (ForwardOperator)this.copyAndSubstituteVar(op, arg);
        ILogicalExpression rangeMapExp = (ILogicalExpression)op.getSideDataExpression().getValue();
        return rangeMapExp.equals(otherRangeMapExp = (ILogicalExpression)otherOp.getSideDataExpression().getValue()) && op.getSideDataKey().equals(otherOp.getSideDataKey());
    }

    @Override
    public Boolean visitSinkOperator(SinkOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.SINK) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitWindowOperator(WindowOperator op, ILogicalOperator arg) throws AlgebricksException {
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.WINDOW) {
            return false;
        }
        WindowOperator windowOpArg = (WindowOperator)this.copyAndSubstituteVar(op, arg);
        if (!IsomorphismOperatorVisitor.compareWindowPartitionSpec(op, windowOpArg)) {
            return false;
        }
        if (!IsomorphismOperatorVisitor.compareWindowFrameSpec(op, windowOpArg)) {
            return false;
        }
        if (!VariableUtilities.varListEqualUnordered(this.getPairList(op.getVariables(), op.getExpressions()), this.getPairList(windowOpArg.getVariables(), windowOpArg.getExpressions()))) {
            return false;
        }
        List<ILogicalPlan> plans = op.getNestedPlans();
        List<ILogicalPlan> plansArg = windowOpArg.getNestedPlans();
        boolean isomorphic = this.compareSubplans(plans, plansArg);
        return isomorphic;
    }

    public static boolean compareWindowPartitionSpec(WindowOperator winOp1, WindowOperator winOp2) {
        return VariableUtilities.varListEqualUnordered(winOp1.getPartitionExpressions(), winOp2.getPartitionExpressions()) && IsomorphismOperatorVisitor.compareIOrderAndExpressions(winOp1.getOrderExpressions(), winOp2.getOrderExpressions());
    }

    public static boolean compareWindowFrameSpec(WindowOperator winOp1, WindowOperator winOp2) {
        return IsomorphismOperatorVisitor.compareWindowFrameSpecExcludingMaxObjects(winOp1, winOp2) && winOp1.getFrameMaxObjects() == winOp2.getFrameMaxObjects();
    }

    public static boolean compareWindowFrameSpecExcludingMaxObjects(WindowOperator winOp1, WindowOperator winOp2) {
        return IsomorphismOperatorVisitor.compareIOrderAndExpressions(winOp1.getFrameValueExpressions(), winOp2.getFrameValueExpressions()) && IsomorphismOperatorVisitor.compareExpressions(winOp1.getFrameStartExpressions(), winOp2.getFrameStartExpressions()) && IsomorphismOperatorVisitor.compareExpressions(winOp1.getFrameStartValidationExpressions(), winOp2.getFrameStartValidationExpressions()) && IsomorphismOperatorVisitor.compareExpressions(winOp1.getFrameEndExpressions(), winOp2.getFrameEndExpressions()) && IsomorphismOperatorVisitor.compareExpressions(winOp1.getFrameEndValidationExpressions(), winOp2.getFrameEndValidationExpressions()) && IsomorphismOperatorVisitor.compareExpressions(winOp1.getFrameExcludeExpressions(), winOp2.getFrameExcludeExpressions()) && winOp1.getFrameExcludeNegationStartIdx() == winOp2.getFrameExcludeNegationStartIdx() && Objects.equals(winOp1.getFrameExcludeUnaryExpression().getValue(), winOp2.getFrameExcludeUnaryExpression().getValue()) && Objects.equals(winOp1.getFrameOffsetExpression().getValue(), winOp2.getFrameOffsetExpression().getValue());
    }

    private static boolean compareExpressions(List<Mutable<ILogicalExpression>> opExprs, List<Mutable<ILogicalExpression>> argExprs) {
        if (opExprs.size() != argExprs.size()) {
            return false;
        }
        for (int i = 0; i < opExprs.size(); ++i) {
            boolean isomorphic = ((ILogicalExpression)opExprs.get(i).getValue()).equals(argExprs.get(i).getValue());
            if (isomorphic) continue;
            return false;
        }
        return true;
    }

    private static boolean compareIOrderAndExpressions(List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> opOrderExprs, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> argOrderExprs) {
        if (opOrderExprs.size() != argOrderExprs.size()) {
            return false;
        }
        for (int i = 0; i < opOrderExprs.size(); ++i) {
            boolean isomorphic = ((OrderOperator.IOrder)opOrderExprs.get((int)i).first).equals(argOrderExprs.get((int)i).first);
            if (!isomorphic) {
                return false;
            }
            isomorphic = ((ILogicalExpression)((Mutable)opOrderExprs.get((int)i).second).getValue()).equals(((Mutable)argOrderExprs.get((int)i).second).getValue());
            if (isomorphic) continue;
            return false;
        }
        return true;
    }

    private boolean compareSubplans(List<ILogicalPlan> plans, List<ILogicalPlan> plansArg) throws AlgebricksException {
        int plansSize = plans.size();
        if (plansSize != plansArg.size()) {
            return false;
        }
        for (int i = 0; i < plansSize; ++i) {
            if (IsomorphismUtilities.isOperatorIsomorphicPlan(plans.get(i), plansArg.get(i))) continue;
            return false;
        }
        return true;
    }

    private ILogicalOperator copyAndSubstituteVar(ILogicalOperator op, ILogicalOperator argOp) throws AlgebricksException {
        ILogicalOperator newOp = OperatorManipulationUtil.deepCopy(argOp);
        this.variableMapping.clear();
        IsomorphismUtilities.mapVariablesTopDown(op, argOp, this.variableMapping);
        ArrayList<LogicalVariable> liveVars = new ArrayList<LogicalVariable>();
        for (int i = 0; i < argOp.getInputs().size(); ++i) {
            VariableUtilities.getLiveVariables((ILogicalOperator)argOp.getInputs().get(i).getValue(), liveVars);
        }
        ArrayList<LogicalVariable> producedVars = new ArrayList<LogicalVariable>();
        VariableUtilities.getProducedVariables(argOp, producedVars);
        ArrayList<LogicalVariable> producedVarsNew = new ArrayList<LogicalVariable>();
        VariableUtilities.getProducedVariables(op, producedVarsNew);
        if (producedVars.size() != producedVarsNew.size()) {
            return newOp;
        }
        for (Map.Entry<LogicalVariable, LogicalVariable> map : this.variableMapping.entrySet()) {
            if (!liveVars.contains(map.getKey())) continue;
            VariableUtilities.substituteVariables(newOp, map.getKey(), map.getValue(), null);
        }
        for (int i = 0; i < producedVars.size(); ++i) {
            VariableUtilities.substituteVariables(newOp, (LogicalVariable)producedVars.get(i), (LogicalVariable)producedVarsNew.get(i), null);
        }
        return newOp;
    }

    public List<Pair<LogicalVariable, ILogicalExpression>> getPairList(List<LogicalVariable> vars, List<Mutable<ILogicalExpression>> exprs) throws AlgebricksException {
        ArrayList<Pair<LogicalVariable, ILogicalExpression>> list = new ArrayList<Pair<LogicalVariable, ILogicalExpression>>();
        if (vars.size() != exprs.size()) {
            throw new AlgebricksException("variable list size does not equal to expression list size ");
        }
        for (int i = 0; i < vars.size(); ++i) {
            list.add((Pair<LogicalVariable, ILogicalExpression>)new Pair((Object)vars.get(i), exprs.get(i).getValue()));
        }
        return list;
    }

    private static boolean variableEqual(LogicalVariable var, LogicalVariable varArg) {
        return Objects.equals(var, varArg);
    }

    @Override
    public Boolean visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, ILogicalOperator arg) throws AlgebricksException {
        boolean isomorphic;
        AbstractLogicalOperator aop = (AbstractLogicalOperator)arg;
        if (aop.getOperatorTag() != LogicalOperatorTag.LEFT_OUTER_UNNEST) {
            return Boolean.FALSE;
        }
        LeftOuterUnnestOperator unnestOpArg = (LeftOuterUnnestOperator)this.copyAndSubstituteVar(op, arg);
        boolean bl = isomorphic = VariableUtilities.varListEqualUnordered(op.getVariables(), unnestOpArg.getVariables()) && IsomorphismOperatorVisitor.variableEqual(op.getPositionalVariable(), unnestOpArg.getPositionalVariable());
        if (!isomorphic) {
            return Boolean.FALSE;
        }
        isomorphic = ((ILogicalExpression)op.getExpressionRef().getValue()).equals(unnestOpArg.getExpressionRef().getValue());
        return isomorphic;
    }
}

