/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.task.HeartbeatAckTask;
import org.apache.hyracks.control.nc.task.PingTask;
import org.apache.hyracks.control.nc.task.ShutdownTask;
import org.apache.hyracks.control.nc.task.ThreadDumpTask;
import org.apache.hyracks.control.nc.work.AbortAllJobsWork;
import org.apache.hyracks.control.nc.work.AbortTasksWork;
import org.apache.hyracks.control.nc.work.ApplicationMessageWork;
import org.apache.hyracks.control.nc.work.CleanupJobletWork;
import org.apache.hyracks.control.nc.work.DeployBinaryWork;
import org.apache.hyracks.control.nc.work.DeployJobSpecWork;
import org.apache.hyracks.control.nc.work.ReportPartitionAvailabilityWork;
import org.apache.hyracks.control.nc.work.StartTasksWork;
import org.apache.hyracks.control.nc.work.StateDumpWork;
import org.apache.hyracks.control.nc.work.UnDeployBinaryWork;
import org.apache.hyracks.control.nc.work.UndeployJobSpecWork;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class NodeControllerIPCI
implements IIPCI {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;

    NodeControllerIPCI(NodeControllerService nodeControllerService) {
        this.ncs = nodeControllerService;
    }

    public void deliverIncomingMessage(IIPCHandle handle, long mid, long rmid, Object payload) {
        CCNCFunctions.Function fn = (CCNCFunctions.Function)payload;
        switch (fn.getFunctionId()) {
            case SEND_APPLICATION_MESSAGE: {
                CCNCFunctions.SendApplicationMessageFunction amf = (CCNCFunctions.SendApplicationMessageFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new ApplicationMessageWork(this.ncs, amf.getMessage(), amf.getDeploymentId(), amf.getNodeId()));
                return;
            }
            case START_TASKS: {
                CCNCFunctions.StartTasksFunction stf = (CCNCFunctions.StartTasksFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new StartTasksWork(this.ncs, stf.getDeploymentId(), stf.getJobId(), stf.getPlanBytes(), stf.getTaskDescriptors(), stf.getConnectorPolicies(), stf.getFlags(), stf.getJobParameters(), stf.getDeployedJobSpecId(), stf.getJobStartTime()));
                return;
            }
            case ABORT_TASKS: {
                CCNCFunctions.AbortTasksFunction atf = (CCNCFunctions.AbortTasksFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new AbortTasksWork(this.ncs, atf.getJobId(), atf.getTasks()));
                return;
            }
            case ABORT_ALL_JOBS: {
                CCNCFunctions.AbortCCJobsFunction aajf = (CCNCFunctions.AbortCCJobsFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new AbortAllJobsWork(this.ncs, aajf.getCcId()));
                return;
            }
            case CLEANUP_JOBLET: {
                CCNCFunctions.CleanupJobletFunction cjf = (CCNCFunctions.CleanupJobletFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new CleanupJobletWork(this.ncs, cjf.getJobId(), cjf.getStatus()));
                return;
            }
            case REPORT_PARTITION_AVAILABILITY: {
                CCNCFunctions.ReportPartitionAvailabilityFunction rpaf = (CCNCFunctions.ReportPartitionAvailabilityFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new ReportPartitionAvailabilityWork(this.ncs, rpaf.getPartitionId(), rpaf.getNetworkAddress()));
                return;
            }
            case NODE_REGISTRATION_RESULT: {
                CCNCFunctions.NodeRegistrationResult nrrf = (CCNCFunctions.NodeRegistrationResult)fn;
                this.ncs.setNodeRegistrationResult(nrrf.getNodeParameters(), nrrf.getException());
                return;
            }
            case GET_NODE_CONTROLLERS_INFO_RESPONSE: {
                CCNCFunctions.GetNodeControllersInfoResponseFunction gncirf = (CCNCFunctions.GetNodeControllersInfoResponseFunction)fn;
                this.ncs.setNodeControllersInfo(gncirf.getNodeControllerInfos());
                return;
            }
            case DEPLOY_BINARY: {
                CCNCFunctions.DeployBinaryFunction dbf = (CCNCFunctions.DeployBinaryFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new DeployBinaryWork(this.ncs, dbf.getDeploymentId(), dbf.getBinaryURLs(), dbf.getCcId()));
                return;
            }
            case UNDEPLOY_BINARY: {
                CCNCFunctions.UnDeployBinaryFunction ndbf = (CCNCFunctions.UnDeployBinaryFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new UnDeployBinaryWork(this.ncs, ndbf.getDeploymentId(), ndbf.getCcId()));
                return;
            }
            case DEPLOY_JOB: {
                CCNCFunctions.DeployJobSpecFunction djf = (CCNCFunctions.DeployJobSpecFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new DeployJobSpecWork(this.ncs, djf.getDeployedJobSpecId(), djf.getacgBytes(), djf.getUpsert(), djf.getCcId()));
                return;
            }
            case UNDEPLOY_JOB: {
                CCNCFunctions.UndeployJobSpecFunction dsjf = (CCNCFunctions.UndeployJobSpecFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new UndeployJobSpecWork(this.ncs, dsjf.getDeployedJobSpecId(), dsjf.getCcId()));
                return;
            }
            case STATE_DUMP_REQUEST: {
                CCNCFunctions.StateDumpRequestFunction dsrf = (CCNCFunctions.StateDumpRequestFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new StateDumpWork(this.ncs, dsrf.getStateDumpId(), dsrf.getCcId()));
                return;
            }
            case SHUTDOWN_REQUEST: {
                CCNCFunctions.ShutdownRequestFunction sdrf = (CCNCFunctions.ShutdownRequestFunction)fn;
                this.ncs.getExecutor().submit(new ShutdownTask(sdrf.isTerminateNCService()));
                return;
            }
            case THREAD_DUMP_REQUEST: {
                CCNCFunctions.ThreadDumpRequestFunction tdrf = (CCNCFunctions.ThreadDumpRequestFunction)fn;
                this.ncs.getExecutor().submit(new ThreadDumpTask(this.ncs, tdrf.getRequestId(), tdrf.getCcId()));
                return;
            }
            case PING_REQUEST: {
                CCNCFunctions.PingFunction pcf = (CCNCFunctions.PingFunction)fn;
                this.ncs.getExecutor().submit(new PingTask(this.ncs, pcf.getCcId()));
                return;
            }
            case NODE_HEARTBEAT_ACK: {
                CCNCFunctions.NodeHeartbeatAckFunction nbaf = (CCNCFunctions.NodeHeartbeatAckFunction)fn;
                this.ncs.getExecutor().submit(new HeartbeatAckTask(this.ncs, nbaf.getCcId(), nbaf.getException()));
                return;
            }
        }
        throw new IllegalArgumentException("Unknown function: " + fn.getFunctionId());
    }

    public void onError(IIPCHandle handle, long mid, long rmid, Exception exception) {
        LOGGER.info("exception in/or processing message", (Throwable)exception);
    }
}

