/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.temporal.ADateParserFactory;
import org.apache.asterix.om.base.temporal.ATimeParserFactory;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class ADateTimeConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ADateTimeConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private AMutableDateTime aDateTime;
                    private ISerializerDeserializer<ADateTime> datetimeSerde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.aDateTime = new AMutableDateTime(0L);
                        this.datetimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        block7: {
                            try {
                                this.resultStorage.reset();
                                this.eval.evaluate(tuple, this.inputArg);
                                if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg)) {
                                    return;
                                }
                                byte[] serString = this.inputArg.getByteArray();
                                int offset = this.inputArg.getStartOffset();
                                int len = this.inputArg.getLength();
                                byte tt = serString[offset];
                                if (tt == ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
                                    result.set((IValueReference)this.inputArg);
                                    break block7;
                                }
                                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                    this.utf8Ptr.set(serString, offset + 1, len - 1);
                                    int stringLength = this.utf8Ptr.getUTF8Length();
                                    int startOffset = this.utf8Ptr.getCharStartOffset();
                                    if (stringLength < 14) {
                                        throw new InvalidDataFormatException(ADateTimeConstructorDescriptor.this.sourceLoc, ADateTimeConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                                    }
                                    short timeOffset = (short)(serString[startOffset] == 45 ? 1 : 0);
                                    timeOffset = (short)(timeOffset + 8);
                                    if (serString[startOffset + timeOffset] != 84 && serString[startOffset + (timeOffset = (short)(timeOffset + 2))] != 84) {
                                        throw new InvalidDataFormatException(ADateTimeConstructorDescriptor.this.sourceLoc, ADateTimeConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                                    }
                                    long chrononTimeInMs = ADateParserFactory.parseDatePart((byte[])serString, (int)startOffset, (int)timeOffset);
                                    this.aDateTime.setValue(chrononTimeInMs += (long)ATimeParserFactory.parseTimePart((byte[])serString, (int)(startOffset + timeOffset + 1), (int)(stringLength - timeOffset - 1)));
                                    this.datetimeSerde.serialize((Object)this.aDateTime, this.out);
                                    result.set((IValueReference)this.resultStorage);
                                    break block7;
                                }
                                throw new TypeMismatchException(ADateTimeConstructorDescriptor.this.sourceLoc, ADateTimeConstructorDescriptor.this.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            catch (IOException e) {
                                throw new InvalidDataFormatException(ADateTimeConstructorDescriptor.this.sourceLoc, ADateTimeConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.DATETIME_CONSTRUCTOR;
    }
}

