# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# generated by datamodel-codegen:
#   filename:  http://0.0.0.0:8080/auth/openapi.json
#   version:   0.28.2
# mypy: disable-error-code="assignment"

from __future__ import annotations

from typing import Annotated, Any

from pydantic import BaseModel, ConfigDict, Field


class HTTPExceptionResponse(BaseModel):
    """
    HTTPException Model used for error response.
    """

    detail: Annotated[str | dict[str, Any], Field(title="Detail")]


class LoginBody(BaseModel):
    """
    Login serializer for post bodies.
    """

    model_config = ConfigDict(
        extra="forbid",
    )
    username: Annotated[str, Field(title="Username")]
    password: Annotated[str, Field(title="Password")]


class LoginResponse(BaseModel):
    """
    Login serializer for responses.
    """

    access_token: Annotated[str, Field(title="Access Token")]


class ValidationError(BaseModel):
    loc: Annotated[list[str | int], Field(title="Location")]
    msg: Annotated[str, Field(title="Message")]
    type: Annotated[str, Field(title="Error Type")]


class HTTPValidationError(BaseModel):
    detail: Annotated[list[ValidationError] | None, Field(title="Detail")] = None
