/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.osgi.security;

import jakarta.servlet.http.HttpServletRequest;
import org.jolokia.server.core.osgi.security.Authenticator;
import org.jolokia.server.core.osgi.security.AuthorizationHeaderParser;

public abstract class BaseAuthenticator
implements Authenticator {
    @Override
    public boolean authenticate(HttpServletRequest pRequest) {
        String auth = pRequest.getHeader("Authorization");
        if (auth == null) {
            auth = pRequest.getHeader("X-jolokia-authorization");
        }
        if (auth == null) {
            return false;
        }
        AuthorizationHeaderParser.Result authInfo = AuthorizationHeaderParser.parse(auth);
        return authInfo.isValid() && this.doAuthenticate(pRequest, authInfo);
    }

    protected abstract boolean doAuthenticate(HttpServletRequest var1, AuthorizationHeaderParser.Result var2);
}

