/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.object;

import java.io.IOException;
import javax.management.openmbean.OpenType;
import org.jolokia.json.JSONStructure;
import org.jolokia.json.parser.JSONParser;
import org.jolokia.json.parser.ParseException;
import org.jolokia.service.serializer.object.OpenTypeDeserializer;

abstract class OpenTypeConverter<T extends OpenType> {
    protected boolean forgiving = false;
    private final OpenTypeDeserializer dispatcher;

    OpenTypeConverter(OpenTypeDeserializer pDispatcher) {
        this.dispatcher = pDispatcher;
    }

    abstract boolean canConvert(OpenType var1);

    abstract Object convertToObject(T var1, Object var2);

    protected JSONStructure toJSON(Object pValue) {
        Class<?> givenClass = pValue.getClass();
        if (JSONStructure.class.isAssignableFrom(givenClass)) {
            return (JSONStructure)pValue;
        }
        try {
            return (JSONStructure)new JSONParser().parse(pValue.toString());
        }
        catch (IOException | ParseException e) {
            throw new IllegalArgumentException("Cannot parse JSON " + pValue + ": " + (Exception)e, e);
        }
        catch (ClassCastException exp) {
            throw new IllegalArgumentException("Given value " + pValue + " cannot be parsed to JSONStructure object: " + exp, exp);
        }
    }

    protected OpenTypeDeserializer getDispatcher() {
        return this.dispatcher;
    }

    protected boolean isForgiving() {
        return this.forgiving || this.dispatcher != null && this.dispatcher.isForgiving();
    }
}

