/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.check;

import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.check.ClusterNodeVerifier;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;
import picocli.CommandLine;

@CommandLine.Command(name="cluster", description={"Verify if all the nodes on the cluster match the same topology and time configuration."})
public class ClusterCheck
extends ConnectionAbstract {
    @CommandLine.Option(names={"--variance"}, description={"Allowed variance in milliseconds before considered a failure. (default=1000)"})
    public long variance = 1000L;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.createConnectionFactory();
        try (ClusterNodeVerifier clusterVerifier = new ClusterNodeVerifier(this.brokerURL, this.user, this.password, this.variance).open();){
            Boolean bl = clusterVerifier.verify(context);
            return bl;
        }
    }
}

